/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IStock;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.data.UiMandant;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class StockSelectorDialog
extends ListDialog {
    private IStock onlyOneStock = null;

    public StockSelectorDialog(Shell parent, boolean includeCommissioningSystems) {
        super(parent);
        List allStocks = StockServiceHolder.get().getAllStocks(includeCommissioningSystems, false);
        if (allStocks.size() == 1) {
            this.onlyOneStock = (IStock)allStocks.get(0);
        }
        this.setInput(allStocks);
        this.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        this.setLabelProvider((ILabelProvider)new StockLabelProvider());
        this.setTitle("Bitte Lager ausw\u00e4hlen");
    }

    public int open() {
        if (this.onlyOneStock != null) {
            return 0;
        }
        return super.open();
    }

    public Object[] getResult() {
        if (this.onlyOneStock != null) {
            return new Object[]{this.onlyOneStock};
        }
        return super.getResult();
    }

    private class StockLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private StockLabelProvider() {
        }

        public String getText(Object element) {
            IStock s = (IStock)element;
            return s.getLabel();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            IStock se = (IStock)element;
            IPerson owner = se.getOwner();
            if (owner != null && owner.isMandator()) {
                IMandator mandator = CoreModelServiceHolder.get().load(owner.getId(), IMandator.class).orElse(null);
                return UiMandant.getColorForIMandator(mandator);
            }
            return null;
        }
    }
}

