/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectFallDialog
extends TitleAreaDialog {
    List<ICoverage> faelle;
    public Fall result;
    org.eclipse.swt.widgets.List list;

    public SelectFallDialog(Shell shell) {
        super(shell);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        GridLayout gl_ret = new GridLayout(1, false);
        gl_ret.marginWidth = 0;
        gl_ret.marginHeight = 0;
        ret.setLayout((Layout)gl_ret);
        this.list = new org.eclipse.swt.widgets.List(ret, 2048);
        this.list.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.reloadFaelleList();
        ToolBarManager tbManager = new ToolBarManager(8388928);
        tbManager.add(GlobalActions.neuerFallAction);
        tbManager.createControl(ret);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SelectFallDialog_selectFall);
        this.setMessage(Messages.SelectFallDialog_pleaseSelectCase);
        this.getShell().setText(Messages.Core_Cases);
    }

    public void okPressed() {
        int sel = this.list.getSelectionIndex();
        this.result = sel == -1 ? null : (Fall)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)this.faelle.get(sel)), Fall.class);
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void reloadFaelleList() {
        this.list.removeAll();
        IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
        if (patient != null) {
            this.faelle = patient != null ? patient.getCoverages() : new ArrayList();
            for (ICoverage f : this.faelle) {
                this.list.add(f.getLabel());
            }
        }
    }

    @Optional
    @Inject
    private void createCoverage(@UIEventTopic(value="info/elexis/model/create") ICoverage iCoverage) {
        CoreUiUtil.runAsyncIfActive(() -> this.reloadFaelleList(), (Object)this.list);
    }

    @Optional
    @Inject
    private void updateCoverage(@UIEventTopic(value="info/elexis/model/update") ICoverage iCoverage) {
        CoreUiUtil.runAsyncIfActive(() -> this.reloadFaelleList(), (Object)this.list);
    }

    protected boolean isResizable() {
        return true;
    }
}

