/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.Messages;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.text.ParseException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class MahnlaufCommand
extends AbstractHandler {
    private static final String STR_STATUS_DATUM = "StatusDatum";
    private static final String STR_MANDANT_I_D = "MandantID";
    private static final String STR_RN_STATUS = "RnStatus";
    public static final String ID = "bill.reminder";
    private IContact biller;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        IMandator mandant = ContextServiceHolder.get().getActiveMandator().orElse(null);
        if (mandant != null) {
            this.biller = mandant.getBiller();
            IQuery qbe = CoreModelServiceHolder.get().getQuery(IMandator.class);
            List allMandants = qbe.execute();
            for (IMandator m : allMandants) {
                if (!m.getBiller().equals(this.biller)) continue;
                this.performMahnlaufForMandant(m.getId());
            }
        }
        return null;
    }

    private void performMahnlaufForMandant(String mandantId) {
        Query qbe = new Query(Rechnung.class);
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.OPEN_AND_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        TimeTool tt = new TimeTool();
        int days = ConfigServiceHolder.get().get(this.biller, "rechnung/days_until_1st", 30);
        Money betrag = new Money();
        try {
            betrag = new Money(ConfigServiceHolder.get().get(this.biller, "rechnung/amount_1st", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        List list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_1);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        }
        qbe.clear();
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.DEMAND_NOTE_1_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        tt = new TimeTool();
        days = ConfigServiceHolder.get().get(this.biller, "rechnung/days_until_2nd", 10);
        try {
            betrag = new Money(ConfigServiceHolder.get().get(this.biller, "rechnung/amount_2nd", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
            betrag = new Money();
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_2);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr2, null);
        }
        qbe.clear();
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.DEMAND_NOTE_2_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        tt = new TimeTool();
        days = ConfigServiceHolder.get().get(this.biller, "rechnung/days_until_3rd", 10);
        try {
            betrag = new Money(ConfigServiceHolder.get().get(this.biller, "rechnung/amount_3rd", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
            betrag = new Money();
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_3);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr3, null);
        }
    }
}

