/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.icons.Images;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class MoveEntryWithinListAction
extends Action {
    private StructuredViewer structuredViewer;
    private List<String> targetCollection;
    private final boolean moveUpwards;

    public MoveEntryWithinListAction(StructuredViewer structuredViewer, List<String> targetCollection, final boolean moveUpwards) {
        this.structuredViewer = structuredViewer;
        this.targetCollection = targetCollection;
        this.moveUpwards = moveUpwards;
        if (moveUpwards) {
            this.setImageDescriptor(Images.IMG_ARROWUP.getImageDescriptor());
            this.setText(Messages.Leistungscodes_moveItemUp);
            this.setAccelerator(0x1400001);
        } else {
            this.setImageDescriptor(Images.IMG_ARROWDOWN.getImageDescriptor());
            this.setText(Messages.Leistungscodes_moveItemDown);
            this.setAccelerator(20971522);
        }
        structuredViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0x400000 && e.keyCode == 0x1000001 && moveUpwards) {
                    MoveEntryWithinListAction.this.run();
                    e.doit = false;
                } else if (e.stateMask == 0x400000 && e.keyCode == 0x1000002 && !moveUpwards) {
                    MoveEntryWithinListAction.this.run();
                    e.doit = false;
                }
            }
        });
    }

    public void run() {
        boolean empty = this.structuredViewer.getSelection().isEmpty();
        if (!empty) {
            int destination;
            Object selectedElement = this.structuredViewer.getStructuredSelection().getFirstElement();
            int j = this.targetCollection.indexOf(selectedElement);
            int n = destination = this.moveUpwards ? j - 1 : j + 1;
            if (destination >= 0 && destination < this.targetCollection.size()) {
                Collections.swap(this.targetCollection, j, destination);
            }
        }
        this.structuredViewer.refresh();
        super.run();
    }
}

