/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Query;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class CovercardFixFallFields
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        pm.beginTask("Bitte warten, F\u00e4lle werden geladen ...", -1);
        String billingSystemStd = ConfigServiceHolder.getGlobal((String)"covercard/billinginfo/std/method", null);
        String billingSystemExc = ConfigServiceHolder.getGlobal((String)"covercard/billinginfo/exc/method", null);
        this.updateCovercardBillingSystem();
        if (StringUtils.isNotBlank((CharSequence)billingSystemStd) || StringUtils.isNotBlank((CharSequence)billingSystemExc)) {
            Query query = new Query(Fall.class);
            query.startGroup();
            query.add("Gesetz", "=", "Covercard");
            if (StringUtils.isNotBlank((CharSequence)billingSystemStd)) {
                query.or();
                query.add("Gesetz", "=", billingSystemStd);
            }
            if (StringUtils.isNotBlank((CharSequence)billingSystemExc)) {
                query.or();
                query.add("Gesetz", "=", billingSystemExc);
            }
            query.endGroup();
            List coverages = query.execute();
            pm.beginTask("Es wurden " + coverages.size() + " F\u00e4lle geladen diese werden nun gepr\u00fcft, bitte warten ...", coverages.size());
            int covercardCount = 0;
            for (Fall fall : coverages) {
                Object infoElement = fall.getInfoElement("Covercard");
                if (infoElement instanceof Map) {
                    ++covercardCount;
                    String billingSystem = fall.getAbrechnungsSystem();
                    this.updateBillingSystem(billingSystem);
                    Map fields = (Map)infoElement;
                    fall.setInfoString("Versicherungsnummer", (String)StringUtils.defaultIfBlank((CharSequence)((String)fields.get("NUM_ASSURE")), (CharSequence)""));
                    fall.setInfoString("VEKANr", (String)StringUtils.defaultIfBlank((CharSequence)((String)fields.get("NUM_UE")), (CharSequence)""));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)fields.get("VAL_CARTE")))) {
                        fall.setInfoString("VEKAValid", "20991231");
                    } else {
                        fall.setInfoString("VEKAValid", (String)fields.get("VAL_CARTE"));
                    }
                }
                pm.worked(1);
            }
            output.append("Es wurden " + covercardCount + " F\u00e4lle mit covercard Informationen gepr\u00fcft");
            pm.done();
        }
        return output.toString();
    }

    private void updateBillingSystem(String billingSystem) {
        Object optionals;
        Object requirements = BillingSystem.getRequirements((String)billingSystem);
        if (!((String)requirements).contains("Versicherungsnummer:T")) {
            requirements = StringUtils.isNotBlank((CharSequence)requirements) ? (String)requirements + ";Versicherungsnummer:T" : "Versicherungsnummer:T";
            ConfigServiceHolder.setGlobal((String)("billing/systems/" + billingSystem + "/bedingungen"), (String)requirements);
        }
        if ((optionals = BillingSystem.getOptionals((String)billingSystem)) == null) {
            optionals = "VEKANr:T";
        } else if (!((String)optionals).contains("VEKANr")) {
            if (((String)optionals).endsWith(":")) {
                optionals = ((String)optionals).substring(0, ((String)optionals).length() - 1);
            }
            optionals = (String)optionals + ";VEKANr:T";
        }
        ConfigServiceHolder.setGlobal((String)("billing/systems/" + billingSystem + "/fakultativ"), (String)optionals);
    }

    private void updateCovercardBillingSystem() {
        String requirements = BillingSystem.getRequirements((String)"Covercard");
        if (requirements.contains("Versicherten-Nummer:T")) {
            requirements = requirements.contains(";Versicherten-Nummer:T") ? requirements.replace(";Versicherten-Nummer:T", "") : (requirements.contains("Versicherten-Nummer:T;") ? requirements.replace("Versicherten-Nummer:T;", "") : requirements.replace("Versicherten-Nummer:T", ""));
        }
        ConfigServiceHolder.setGlobal((String)"billing/systems/Covercard/bedingungen", (String)requirements);
        Object optionals = BillingSystem.getOptionals((String)"Covercard");
        if (optionals == null || !((String)optionals).contains("VEKANr")) {
            optionals = StringUtils.isNotBlank((CharSequence)optionals) ? (String)optionals + ";VEKANr:T" : "VEKANr:T";
            ConfigServiceHolder.setGlobal((String)"billing/systems/Covercard/fakultativ", (String)optionals);
        }
    }

    @Override
    public String getMaintenanceDescription() {
        return "Covercard Informationen der F\u00e4lle pr\u00fcfen und richtig stellen";
    }
}

