/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.composites.AllergyIntoleranceComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import java.util.Optional;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AllergyIntoleranceEditDialog
extends TitleAreaDialog {
    private AllergyIntoleranceComposite conditionComposite;
    private Optional<IAllergyIntolerance> allergyIntolerance = Optional.empty();
    private IAllergyIntolerance.AllergyIntoleranceCategory category;

    public AllergyIntoleranceEditDialog(IAllergyIntolerance.AllergyIntoleranceCategory category, Shell parentShell) {
        super(parentShell);
        this.category = category;
        this.setShellStyle(2160);
    }

    public AllergyIntoleranceEditDialog(IAllergyIntolerance allergyIntolerance, Shell parentShell) {
        super(parentShell);
        this.allergyIntolerance = Optional.of(allergyIntolerance);
        this.category = allergyIntolerance.getCategory();
        this.setShellStyle(2160);
    }

    public void create() {
        super.create();
        this.setTitle(this.category.getLocalized() + " Daten " + (this.allergyIntolerance.isPresent() ? "editieren" : "anlegen") + ".");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new FillLayout());
        this.conditionComposite = new AllergyIntoleranceComposite(ret, 0);
        this.conditionComposite.setAllergyIntolerance(this.allergyIntolerance);
        return ret;
    }

    protected void okPressed() {
        this.allergyIntolerance = this.conditionComposite.getAllergyIntolerance();
        FindingsServiceComponent.getService().saveFinding((IFinding)this.allergyIntolerance.get());
        super.okPressed();
    }

    public Optional<IAllergyIntolerance> getAllergyIntolerance() {
        return this.allergyIntolerance;
    }
}

