/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.importer;

import ch.elexis.core.findings.util.importer.FhirBundleReferenceDataImporter;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"referenceDataId=insurances"}, service={IReferenceDataImporter.class})
public class InsurancesReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static final String REFERENCEDATA_MANAGEDINSURANCE_VERSION = "referencedata/managedinsurance/version";
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(referenceDataId=fhirbundle)")
    private IReferenceDataImporter fhirBundleImporter;
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private IStickerService stickerService;
    private ISticker sticker;
    private Optional<ISticker> readOnlySticker;

    public int getCurrentVersion() {
        return ConfigServiceHolder.get().get(REFERENCEDATA_MANAGEDINSURANCE_VERSION, 0);
    }

    public IStatus performImport(IProgressMonitor ipm, InputStream input, Integer newVersion) {
        this.accessControlService.doPrivileged(() -> {
            this.sticker = this.getOrCreateInsuranceSticker();
            this.readOnlySticker = this.coreModelService.load("readOnly", ISticker.class);
        });
        IStatus ret = ((FhirBundleReferenceDataImporter)this.fhirBundleImporter).performImport(ipm, input, newVersion, o -> {
            if (o instanceof IOrganization) {
                IOrganization insurance = (IOrganization)o;
                if (!this.stickerService.hasSticker((Identifiable)insurance, this.sticker)) {
                    this.stickerService.addSticker(this.sticker, (Identifiable)insurance);
                }
                if (this.readOnlySticker.isPresent() && !StickerServiceHolder.get().hasSticker((Identifiable)insurance, this.readOnlySticker.get())) {
                    this.stickerService.addSticker(this.readOnlySticker.get(), (Identifiable)insurance);
                }
            }
        });
        if (ret.isOK() && newVersion != null) {
            ConfigServiceHolder.get().set(REFERENCEDATA_MANAGEDINSURANCE_VERSION, newVersion.intValue());
        }
        return ret;
    }

    private ISticker getOrCreateInsuranceSticker() {
        ISticker insuranceSticker = this.coreModelService.load("managedinsurance", ISticker.class).orElse(null);
        if (insuranceSticker == null) {
            insuranceSticker = (ISticker)this.coreModelService.create(ISticker.class);
            insuranceSticker.setId("managedinsurance");
            insuranceSticker.setName("Versicherung");
            insuranceSticker.setBackground("e0e1e8");
            this.coreModelService.save((Identifiable)insuranceSticker);
            this.stickerService.setStickerAddableToClass(IOrganization.class, insuranceSticker);
        }
        return insuranceSticker;
    }
}

