/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IPersonPersonAttributeMapper;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Person;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"transformer.id=Person.IPerson"})
public class PersonIPersonTransformer
implements IFhirTransformer<Person, IPerson> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    @Reference
    private IUserService userService;
    private IPersonPersonAttributeMapper attributeMapper;

    @Activate
    private void activate() {
        this.attributeMapper = new IPersonPersonAttributeMapper(this.modelService, this.xidService);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Person.class.equals(fhirClazz) && IPerson.class.equals(localClazz);
    }

    @Override
    public Optional<Person> getFhirObject(IPerson localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Person person = new Person();
        this.attributeMapper.elexisToFhir(localObject, person, summaryEnum, includes);
        return Optional.of(person);
    }

    @Override
    public Optional<IPerson> getLocalObject(Person fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.modelService.load(localId.get(), IPerson.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends Identifiable> getLocalObjectForReference(String fhirReference) {
        Optional<String> localId;
        if (fhirReference.startsWith(Person.class.getSimpleName()) && (localId = FhirUtil.getLocalId(fhirReference)).isPresent()) {
            return this.modelService.load(localId.get(), IPerson.class);
        }
        return IFhirTransformer.super.getLocalObjectForReference(fhirReference);
    }

    @Override
    public Optional<IPerson> updateLocalObject(Person fhirObject, IPerson localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IPerson> createLocalObject(Person fhirObject) {
        IPerson create = (IPerson)this.modelService.create(IPerson.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.modelService.save((Identifiable)create);
        return Optional.of(create);
    }
}

