/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerException;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IDocumentAttributeMapper;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IModelService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Meta;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class DocumentReferenceIDocumentReferenceTransformer
implements IFhirTransformer<DocumentReference, IDocumentReference> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private List<IDocumentStore> documentStores;
    @Reference
    private IFindingsService findingsService;
    private FindingsContentHelper contentHelper;
    private IDocumentAttributeMapper attributeMapper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
        this.attributeMapper = new IDocumentAttributeMapper(this.documentStores);
    }

    @Override
    public Optional<DocumentReference> getFhirObject(IDocumentReference localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            DocumentReference ret = (DocumentReference)resource.get();
            if (ret.getContent().isEmpty()) {
                IDocument document = localObject.getDocument();
                if (document != null) {
                    this.attributeMapper.elexisToFhir(document, ret, summaryEnum, includes);
                    ret.setId((IIdType)new IdDt(DocumentReference.class.getSimpleName(), localObject.getId()));
                    Meta meta = new Meta();
                    meta.setLastUpdated(new Date(localObject.getLastupdate()));
                    ret.setMeta(meta);
                    if (ret.hasContent() && ((DocumentReference.DocumentReferenceContentComponent)ret.getContent().get(0)).hasAttachment()) {
                        ((DocumentReference.DocumentReferenceContentComponent)ret.getContent().get(0)).getAttachment().setUrl(this.getBinaryUrl(ret));
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).error("No document with content found for reference " + String.valueOf(ret));
                }
            }
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    private String getBinaryUrl(DocumentReference ret) {
        return ret.getId() + "/$binary-access-read";
    }

    @Override
    public Optional<IDocumentReference> getLocalObject(DocumentReference fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.findingsService.findById(localId.get(), IDocumentReference.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IDocumentReference> updateLocalObject(DocumentReference fhirObject, IDocumentReference localObject) {
        IDocument document = localObject.getDocument();
        this.attributeMapper.fhirToElexis(fhirObject, document);
        this.saveDocument(document);
        return Optional.of(localObject);
    }

    private void saveDocument(IDocument document) {
        Optional<IDocumentStore> documentStore = this.getDocumentStoreWithId(document.getStoreId());
        if (documentStore.isPresent()) {
            try {
                documentStore.get().saveDocument(document);
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error saving document", (Throwable)e);
                throw new IFhirTransformerException("WARNING", "Error saving document", 500);
            }
        } else {
            throw new IFhirTransformerException("WARNING", "No document store for document", 412);
        }
    }

    @Override
    public Optional<IDocumentReference> createLocalObject(DocumentReference fhirObject) {
        if (fhirObject.getContent() != null && !fhirObject.getContent().isEmpty()) {
            Optional patient;
            DocumentReference.DocumentReferenceContentComponent content = (DocumentReference.DocumentReferenceContentComponent)fhirObject.getContent().get(0);
            Attachment attachment = content.getAttachment();
            Optional<String> patientId = FhirUtil.getId(fhirObject.getSubject());
            if (patientId.isPresent() && !(patient = this.coreModelService.load(patientId.get(), IPatient.class)).isPresent()) {
                throw new IFhirTransformerException("WARNING", "Invalid patient", 412);
            }
            IDocumentStore documentStore = this.getDocumentStoreId(fhirObject);
            IDocument document = this.createDocument(patientId.orElse(null), attachment, this.attributeMapper.getAccessor().getCategory((DomainResource)fhirObject).orElse(documentStore.getCategoryDefault().getName()), documentStore);
            IDocumentReference iDocumentReference = (IDocumentReference)this.findingsService.create(IDocumentReference.class);
            iDocumentReference.setDocument(document);
            this.attributeMapper.fhirToElexis(fhirObject, document);
            this.saveDocument(document);
            fhirObject.getContent().clear();
            this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iDocumentReference);
            this.findingsService.saveFinding((IFinding)iDocumentReference);
            return Optional.of(iDocumentReference);
        }
        return Optional.empty();
    }

    private IDocumentStore getDocumentStoreId(DocumentReference fhirObject) {
        Optional<String> storeIdCode;
        if (fhirObject.hasCategory() && (storeIdCode = FhirUtil.getCodeFromConceptList(CodingSystem.ELEXIS_DOCUMENT_STOREID.getSystem(), fhirObject.getCategory())).isPresent()) {
            return this.getDocumentStoreWithId(storeIdCode.get()).orElse(this.getDefaultDocumentStore());
        }
        return this.getDefaultDocumentStore();
    }

    private IDocumentStore getDefaultDocumentStore() {
        if (!this.documentStores.isEmpty()) {
            return this.documentStores.stream().filter(ds -> ds.getId().toLowerCase().contains("omnivore")).findFirst().orElse(this.documentStores.get(0));
        }
        throw new IllegalStateException("No document stores available");
    }

    private Optional<IDocumentStore> getDocumentStoreWithId(String id) {
        return this.documentStores.stream().filter(ds -> ds.getId().equals(id)).findFirst();
    }

    private IDocument createDocument(String patientId, Attachment attachment, String category, IDocumentStore documentStore) {
        IDocument ret;
        block28: {
            ret = documentStore.createDocument(patientId, attachment.getTitle(), category);
            if (StringUtils.isNotBlank((CharSequence)attachment.getContentType())) {
                ret.setMimeType(attachment.getContentType());
            }
            try {
                documentStore.saveDocument(ret);
                if (attachment == null) break block28;
                if (attachment.getData() != null) {
                    try {
                        Throwable throwable = null;
                        Object var7_12 = null;
                        try (ByteArrayInputStream in = new ByteArrayInputStream(attachment.getData());){
                            documentStore.saveDocument(ret, (InputStream)in);
                            break block28;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error reading content from attachment data [" + attachment.getUrl() + "]", e);
                    }
                    break block28;
                }
                if (!StringUtils.isNotBlank((CharSequence)attachment.getUrl()) || !attachment.getUrl().contains("://")) break block28;
                try {
                    URL url = new URL(attachment.getUrl());
                    try {
                        Throwable throwable = null;
                        Object var8_18 = null;
                        try (InputStream in = url.openStream();){
                            documentStore.saveDocument(ret, in);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error reading content from url [" + attachment.getUrl() + "]", e);
                    }
                }
                catch (MalformedURLException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Attachment url invalid", (Throwable)e);
                }
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating document", (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return DocumentReference.class.equals(fhirClazz) && IDocumentReference.class.equals(localClazz);
    }
}

