/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerException;
import ch.elexis.core.findings.util.fhir.transformer.helper.CodeSystemUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.status.StatusUtil;
import ch.rgw.tools.Result;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Quantity;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ChargeItemIBilledTransformer
implements IFhirTransformer<ChargeItem, IBilled> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IBillingService billingService;
    @Reference
    private ICodeElementService codeElementService;
    @Reference
    private IContextService contextService;

    @Override
    public Optional<ChargeItem> getFhirObject(IBilled localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        IArticle article;
        String gtin;
        ChargeItem chargeItem = new ChargeItem();
        chargeItem.setId((IIdType)new IdDt("ChargeItem", localObject.getId(), Long.toString(localObject.getLastupdate())));
        chargeItem.setStatus(ChargeItem.ChargeItemStatus.BILLED);
        chargeItem.setContext(FhirUtil.getReference((Identifiable)localObject.getEncounter()));
        CodeableConcept code = new CodeableConcept();
        chargeItem.setCode(code);
        IBillable billable = localObject.getBillable();
        if (billable instanceof IArticle && StringUtils.isNotBlank((CharSequence)(gtin = (article = (IArticle)billable).getGtin()))) {
            code.addCoding(CodeSystemUtil.getGtinCoding(gtin));
        }
        code.addCoding(CodeSystemUtil.getCodeElementCoding(this.codeElementService, (ICodeElement)billable));
        chargeItem.setQuantity(new Quantity(localObject.getAmount()));
        return Optional.of(chargeItem);
    }

    @Override
    public Optional<IBilled> getLocalObject(ChargeItem fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.coreModelService.load(id, IBilled.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IBilled> updateLocalObject(ChargeItem fhirObject, IBilled localObject) {
        this.assertMandator(fhirObject, localObject.getEncounter().getMandator());
        Quantity quantity = fhirObject.getQuantity();
        IStatus status = this.billingService.changeAmountValidated(localObject, quantity.getValue().doubleValue());
        if (!status.isOK()) {
            throw new IFhirTransformerException(StatusUtil.getSeverityString((int)status.getSeverity()), status.getMessage(), status.getCode());
        }
        return Optional.of(localObject);
    }

    @Override
    public Optional<IBilled> createLocalObject(ChargeItem fhirObject) {
        IEncounter encounter = this.assertEncounter(fhirObject);
        this.assertMandator(fhirObject, encounter.getMandator());
        IBillable billable = this.assertBillable(fhirObject);
        Result result = this.billingService.bill(billable, encounter, fhirObject.getQuantity().getValue().doubleValue());
        if (!result.isOK()) {
            throw new IFhirTransformerException(result.getSeverity().name(), result.getCombinedMessages(), result.getCode());
        }
        return Optional.of((IBilled)result.get());
    }

    private void assertMandator(ChargeItem fhirObject, IMandator encounterMandator) {
        List performers = fhirObject.getPerformer();
        if (performers.isEmpty()) {
            if (encounterMandator != null) {
                this.contextService.setActiveMandator(encounterMandator);
                return;
            }
            throw new IFhirTransformerException("WARNING", "No performer set or available via encounter", 0);
        }
        String mandatorId = ((ChargeItem.ChargeItemPerformerComponent)performers.get(0)).getActor().getReferenceElement().getIdPart();
        IMandator mandator = this.coreModelService.load(mandatorId, IMandator.class).orElse(null);
        if (mandator == null) {
            throw new IFhirTransformerException("WARNING", "Unresolvable mandator", 0);
        }
        this.contextService.setActiveMandator(mandator);
    }

    private IBillable assertBillable(ChargeItem fhirObject) {
        Optional<ICodeElement> iCodeElement = CodeSystemUtil.loadCodeElementEntryInCodeableConcept(this.codeElementService, fhirObject.getCode());
        if (iCodeElement.isEmpty()) {
            throw new IFhirTransformerException("WARNING", "No codeElement found", 412);
        }
        ICodeElement _iCodeElement = iCodeElement.get();
        if (!(_iCodeElement instanceof IBillable)) {
            throw new IFhirTransformerException("WARNING", "Non-billable codeElement found", 412);
        }
        return (IBillable)_iCodeElement;
    }

    private IEncounter assertEncounter(ChargeItem fhirObject) {
        IIdType referenceElement = fhirObject.getContext().getReferenceElement();
        String encounterId = referenceElement.getIdPart();
        if (StringUtils.isBlank((CharSequence)encounterId)) {
            throw new IFhirTransformerException("WARNING", "Missing encounter parameter", 412);
        }
        IEncounter encounter = this.coreModelService.load(encounterId, IEncounter.class).orElse(null);
        if (encounter == null) {
            throw new IFhirTransformerException("WARNING", "Invalid encounter", 412);
        }
        return encounter;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return ChargeItem.class.equals(fhirClazz) && IBilled.class.equals(localClazz);
    }
}

