/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.rs232;

import ch.elexis.core.serial.Connection;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.importer.div.rs232.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SerialConnectionUi {
    public static Thread awaitFrame(Connection connection, Shell shell, String text, int timeout, boolean background, boolean adjustEndTime) {
        long endTime = System.currentTimeMillis() + (long)(timeout * 1000);
        Thread watchdogThread = null;
        watchdogThread = background ? new Thread(new BackgroundWatchdog(connection, endTime)) : new Thread(new MonitoredWatchdog(connection, shell, text, endTime));
        watchdogThread.start();
        return watchdogThread;
    }

    static class BackgroundWatchdog
    implements Runnable {
        private Connection connection;
        private long endTime;

        public BackgroundWatchdog(Connection connection, long endTime) {
            this.connection = connection;
            this.endTime = endTime;
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() < this.endTime && this.connection.isOpen()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            this.connection.close();
        }
    }

    static class MonitoredWatchdog
    implements Runnable {
        private Connection connection;
        private long endTime;
        final Shell shell;
        final String text;

        public MonitoredWatchdog(Connection connection, Shell shell, String text, long endTime) {
            this.connection = connection;
            this.endTime = endTime;
            this.shell = shell;
            this.text = text;
        }

        @Override
        public void run() {
            final IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){
                private int count = 0;

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setTaskName(Messages.AbstractConnection_PleaseWait);
                    while (!monitor.isCanceled() && System.currentTimeMillis() < endTime && connection.isOpen()) {
                        if (this.count == 160) {
                            monitor.beginTask(text, 100);
                            this.count = 0;
                        }
                        if (monitor.isCanceled()) {
                            monitor.done();
                            return;
                        }
                        monitor.worked(1);
                        ++this.count;
                        Thread.sleep(10L);
                    }
                    connection.close();
                    monitor.done();
                }
            };
            Thread monitorDialogThread = new Thread(){

                @Override
                public void run() {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    try {
                        dialog.run(true, true, runnableWithProgress);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            UiDesk.getDisplay().asyncExec((Runnable)monitorDialogThread);
        }
    }
}

