/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v2x;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ED;
import ca.uhn.hl7v2.model.v26.datatype.FN;
import ca.uhn.hl7v2.model.v26.datatype.FT;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SN;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_PATIENT;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_PATIENT_RESULT;
import ca.uhn.hl7v2.model.v26.group.OUL_R24_ORDER;
import ca.uhn.hl7v2.model.v26.group.OUL_R24_PATIENT;
import ca.uhn.hl7v2.model.v26.group.OUL_R24_SPECIMEN;
import ca.uhn.hl7v2.model.v26.message.ORU_R01;
import ca.uhn.hl7v2.model.v26.message.OUL_R24;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.elexis.hl7.util.HL7Helper;
import ch.elexis.hl7.v26.Messages;
import ch.rgw.tools.StringTool;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ReaderV26
extends HL7Reader {
    static Logger logger = LoggerFactory.getLogger(HL7ReaderV26.class);

    public HL7ReaderV26(Message message) {
        super(message);
    }

    @Override
    public String getSender() throws ElexisException {
        String sender;
        try {
            MSH msh = (MSH)this.message.get("MSH");
            sender = msh.getMsh4_SendingFacility().getNamespaceID().getValue();
            if (sender == null && (sender = msh.getMsh3_SendingApplication().getNamespaceID().getValue()) == null) {
                sender = "";
            }
        }
        catch (HL7Exception e) {
            throw new ElexisException(e.getMessage(), (Throwable)e);
        }
        return sender;
    }

    @Override
    public ObservationMessage readObservation(HL7PatientResolver patientResolver, boolean createIfNotFound) throws ElexisException {
        this.observation = null;
        try {
            this.patientResolver = patientResolver;
            if (this.message.getName().contains("OUL_R24")) {
                this.readObservationOulR24(createIfNotFound);
            } else {
                this.readObservationOruR01(createIfNotFound);
            }
        }
        catch (HL7Exception | ParseException e) {
            throw new ElexisException(e.getMessage(), e);
        }
        return this.observation;
    }

    private void readObservationOulR24(boolean createIfNotFound) throws ParseException, DataTypeException {
        OUL_R24 oul = (OUL_R24)this.message;
        this.setPatient(oul, createIfNotFound);
        int obrCount = oul.getORDERReps();
        int idx = 0;
        while (idx < obrCount) {
            OBR obr = oul.getORDER(idx).getOBR();
            String obrObservationDateTime = obr.getObr7_ObservationDateTime().getValue();
            this.setOrderComment(oul, idx, obrObservationDateTime);
            int i = 0;
            while (i < oul.getORDER(idx).getSPECIMENReps()) {
                OUL_R24_SPECIMEN specimen = oul.getORDER(idx).getSPECIMEN(i);
                String group = "";
                String sequence = "";
                int k = 0;
                while (k < 2) {
                    CWE cwe = obr.getObr47_FillerSupplementalServiceInformation(k);
                    if (cwe != null) {
                        String code = "";
                        if (cwe.getCwe3_NameOfCodingSystem() != null) {
                            code = cwe.getCwe3_NameOfCodingSystem().getValue();
                        }
                        group = this.getGroup(code, cwe);
                        sequence = this.getSequence(code, cwe);
                    }
                    ++k;
                }
                int obxIdx = 0;
                while (obxIdx < specimen.getOBXReps()) {
                    this.readOBXResults(specimen.getOBX(obxIdx), "", group, sequence, obrObservationDateTime);
                    ++obxIdx;
                }
                ++i;
            }
            ++idx;
        }
    }

    private void readObservationOruR01(boolean createIfNotFound) throws HL7Exception, ParseException {
        ORU_R01 oru = (ORU_R01)this.message;
        this.setPatient(oru, createIfNotFound);
        int obsCount = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
        int idx = 0;
        while (idx < obsCount) {
            OBR obr = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBR();
            String obrObservationDateTime = obr.getObr7_ObservationDateTime().getValue();
            this.setOrderComment(oru, idx, obrObservationDateTime);
            int i = 0;
            while (i < oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBSERVATIONReps()) {
                ORU_R01_ORDER_OBSERVATION obs = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx);
                String commentNTE = this.getComments(obs, i);
                String group = "";
                String sequence = "";
                int k = 0;
                while (k < 2) {
                    CWE cwe = obr.getObr47_FillerSupplementalServiceInformation(k);
                    if (cwe != null) {
                        String code = "";
                        if (cwe.getCwe3_NameOfCodingSystem() != null) {
                            code = cwe.getCwe3_NameOfCodingSystem().getValue();
                        }
                        group = this.getGroup(code, cwe);
                        sequence = this.getSequence(code, cwe);
                    }
                    ++k;
                }
                this.readOBXResults(obs.getOBSERVATION(i).getOBX(), commentNTE, group, sequence, obrObservationDateTime);
                ++i;
            }
            ++idx;
        }
    }

    private String getGroup(String code, CWE cwe) {
        if ("99DGC".equalsIgnoreCase(code) && cwe.getCwe2_Text() != null) {
            return cwe.getCwe2_Text().getValue();
        }
        return "";
    }

    private String getSequence(String code, CWE cwe) {
        if ("99DGP".equalsIgnoreCase(code) && cwe.getCwe1_Identifier() != null) {
            return cwe.getCwe1_Identifier().getValue();
        }
        return "";
    }

    private void setPatient(OUL_R24 oul, boolean createIfNotFound) throws ParseException, DataTypeException {
        List<Object> list = new ArrayList();
        String lastName = "";
        String firstName = "";
        String birthDate = "";
        String sex = Gender.FEMALE.value();
        this.pat = null;
        if (this.pat == null) {
            String sendingApplication = oul.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue();
            String sendingFacility = oul.getMSH().getMsh4_SendingFacility().getHd1_NamespaceID().getValue();
            String dateTimeOfMessage = oul.getMSH().getMsh7_DateTimeOfMessage().getValue();
            PID pid = oul.getPATIENT().getPID();
            String patid = pid.getPatientID().getIDNumber().getValue();
            String patid_alternative = pid.getPid4_AlternatePatientIDPID(0).getCx1_IDNumber().getValue();
            if (StringTool.isNothing((Object)patid) && StringTool.isNothing((Object)(patid = pid.getPatientID().getCx1_IDNumber().getValue())) && StringTool.isNothing((Object)(patid = pid.getPid2_PatientID().getIDNumber().getValue())) && StringTool.isNothing((Object)(patid = pid.getAlternatePatientIDPID(0).getCx1_IDNumber().getValue())) && (patid = patid_alternative) == null) {
                patid = "";
            }
            if (patid != null) {
                list = this.patientResolver.getPatientById(patid);
            }
            String orderNumber = oul.getORDER().getORC().getOrc2_PlacerOrderNumber().getEi1_EntityIdentifier().getValue();
            if (pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue() != null) {
                lastName = pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue();
            }
            if (pid.getPid5_PatientName(0).getGivenName().getValue() != null) {
                firstName = pid.getPid5_PatientName(0).getGivenName().getValue();
            }
            String patientName = firstName + " " + lastName;
            String patientNotesAndComments = this.readPatientNotesAndComments(oul.getPATIENT());
            this.observation = new ObservationMessage(sendingApplication, sendingFacility, dateTimeOfMessage, patid, patientName, patientNotesAndComments, patid_alternative, orderNumber);
            birthDate = pid.getDateTimeOfBirth().getValue();
            sex = pid.getAdministrativeSex().getValue();
            if (patid == null || list.size() != 1) {
                list = this.patientResolver.findPatientByNameAndBirthdate(lastName, firstName, birthDate);
                if (list != null && list.size() == 1) {
                    this.pat = (IPatient)list.get(0);
                } else if (createIfNotFound) {
                    String phone = "";
                    XAD adr = pid.getPatientAddress(0);
                    phone = pid.getPhoneNumberHome(0).getTelephoneNumber().getValue();
                    this.pat = this.patientResolver.createPatient(lastName, firstName, birthDate, sex);
                    this.pat.setPatientNr(patid);
                    if (adr != null) {
                        if (adr.getStreetAddress() != null) {
                            this.pat.setStreet(adr.getStreetAddress().getComponent(0).toString());
                        }
                        if (adr.getZipOrPostalCode() != null) {
                            this.pat.setZip(adr.getZipOrPostalCode().getValue());
                        }
                        if (adr.getCity() != null) {
                            this.pat.setCity(adr.getCity().getValue());
                        }
                        if (adr.getCountry() != null) {
                            try {
                                Country cc = Country.valueOf((String)adr.getCountry().getValue());
                                this.pat.setCountry(cc);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.pat.setPhone1(phone);
                } else {
                    this.resolvePatient(patid, firstName, lastName, birthDate);
                }
            } else {
                this.pat = (IPatient)list.get(0);
                if (lastName.length() != 0 && firstName.length() != 0) {
                    this.checkConflict(firstName, lastName, birthDate, sex, patid);
                }
            }
        }
    }

    private void setPatient(ORU_R01 oru, boolean createIfNotFound) throws ParseException, HL7Exception {
        List<Object> list = new ArrayList();
        String lastName = "";
        String firstName = "";
        String birthDate = "";
        String sex = Gender.FEMALE.value();
        this.pat = null;
        if (this.pat == null) {
            String sendingApplication = oru.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue();
            String sendingFacility = oru.getMSH().getMsh4_SendingFacility().getHd1_NamespaceID().getValue();
            String dateTimeOfMessage = oru.getMSH().getMsh7_DateTimeOfMessage().getValue();
            PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
            String patid = pid.getPatientID().getIDNumber().getValue();
            String patid_alternative = pid.getPid4_AlternatePatientIDPID(0).getCx1_IDNumber().getValue();
            if (StringTool.isNothing((Object)patid) && StringTool.isNothing((Object)(patid = pid.getPatientID().getCx1_IDNumber().getValue())) && StringTool.isNothing((Object)(patid = pid.getPid2_PatientID().getIDNumber().getValue())) && StringTool.isNothing((Object)(patid = pid.getAlternatePatientIDPID(0).getCx1_IDNumber().getValue())) && (patid = patid_alternative) == null) {
                patid = "";
            }
            if (patid != null) {
                list = this.patientResolver.getPatientById(patid);
            }
            String orderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PlacerOrderNumber().getEi1_EntityIdentifier().getValue();
            if (pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue() != null) {
                lastName = pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue();
            }
            if (pid.getPid5_PatientName(0).getGivenName().getValue() != null) {
                firstName = pid.getPid5_PatientName(0).getGivenName().getValue();
            }
            String patientName = firstName + " " + lastName;
            String patientNotesAndComments = this.readPatientNotesAndComments(oru.getPATIENT_RESULT().getPATIENT());
            this.observation = new ObservationMessage(sendingApplication, sendingFacility, dateTimeOfMessage, patid, patientName, patientNotesAndComments, patid_alternative, orderNumber);
            birthDate = pid.getDateTimeOfBirth().getValue();
            sex = pid.getAdministrativeSex().getValue();
            if (patid == null || list.size() != 1) {
                list = this.patientResolver.findPatientByNameAndBirthdate(lastName, firstName, birthDate);
                if (list != null && list.size() == 1) {
                    this.pat = (IPatient)list.get(0);
                } else if (createIfNotFound) {
                    String phone = "";
                    XAD adr = pid.getPatientAddress(0);
                    phone = pid.getPhoneNumberHome(0).getTelephoneNumber().getValue();
                    this.pat = this.patientResolver.createPatient(lastName, firstName, birthDate, sex);
                    this.pat.setPatientNr(patid);
                    if (adr != null) {
                        if (adr.getStreetAddress() != null) {
                            this.pat.setStreet(adr.getStreetAddress().getComponent(0).toString());
                        }
                        if (adr.getZipOrPostalCode() != null) {
                            this.pat.setZip(adr.getZipOrPostalCode().getValue());
                        }
                        if (adr.getCity() != null) {
                            this.pat.setCity(adr.getCity().getValue());
                        }
                        if (adr.getCountry() != null) {
                            try {
                                Country cc = Country.valueOf((String)adr.getCountry().getValue());
                                this.pat.setCountry(cc);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.pat.setPhone1(phone);
                } else {
                    this.resolvePatient(patid, firstName, lastName, birthDate);
                }
            } else {
                this.pat = (IPatient)list.get(0);
                if (lastName.length() != 0 && firstName.length() != 0) {
                    this.checkConflict(firstName, lastName, birthDate, sex, patid);
                }
            }
        }
    }

    private String readPatientNotesAndComments(ORU_R01_PATIENT patient) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < patient.getNTEReps()) {
            FT comment = patient.getNTE(i).getComment(0);
            sb.append(comment.toString());
            if (patient.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private String readPatientNotesAndComments(OUL_R24_PATIENT patient) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < patient.getNTEReps()) {
            FT comment = patient.getNTE(i).getComment(0);
            sb.append(comment.toString());
            if (patient.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private void setOrderComment(ORU_R01 oru, int idx, String obsDate) throws ParseException {
        String orderCommentNTE = this.getComments(oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx), -1);
        if (orderCommentNTE != null) {
            this.observation.add(new TextData("Kommentar", orderCommentNTE, obsDate, "00 Kommentar", null));
        }
    }

    private void setOrderComment(OUL_R24 oul, int idx, String obsDate) throws ParseException {
        String orderCommentNTE = this.getComments(oul.getORDER(idx), -1);
        if (orderCommentNTE != null) {
            this.observation.add(new TextData("Kommentar", orderCommentNTE, obsDate, "00 Kommentar", null));
        }
    }

    private String getComments(ORU_R01_ORDER_OBSERVATION oobs, int i) {
        Object commentNTE = null;
        int size = oobs.getNTEReps();
        if (i > -1) {
            size = oobs.getOBSERVATION(i).getNTEReps();
        }
        int n = 0;
        while (n < size) {
            FT comment;
            NTE nte = oobs.getNTE(n);
            if (i > -1) {
                nte = oobs.getOBSERVATION(i).getNTE(n);
            }
            if ((comment = nte.getNte3_Comment(0)) != null) {
                commentNTE = commentNTE != null ? commentNTE + "\n" : "";
                if (comment.getValue() != null) {
                    commentNTE = (String)commentNTE + comment.getValue();
                }
            }
            ++n;
        }
        return commentNTE;
    }

    private String getComments(OUL_R24_ORDER order, int i) {
        Object commentNTE = null;
        int size = order.getNTEReps();
        int n = 0;
        while (n < size) {
            NTE nte = order.getNTE(n);
            FT comment = nte.getNte3_Comment(0);
            if (comment != null) {
                commentNTE = commentNTE != null ? commentNTE + "\n" : "";
                if (comment.getValue() != null) {
                    commentNTE = (String)commentNTE + comment.getValue();
                }
            }
            ++n;
        }
        return commentNTE;
    }

    private void readOBXResults(OBX obx, String commentNTE, String group, String sequence, String defaultDateTime) throws ParseException {
        String valueType = obx.getObx2_ValueType().getValue();
        String name = "";
        String itemCode = "";
        String unit = "";
        String range = "";
        String observationTime = "";
        String status = "";
        if (valueType.equals("ED")) {
            String observationId = obx.getObx3_ObservationIdentifier().getCwe1_Identifier().getValue();
            if (!"DOCUMENT".equals(observationId)) {
                logger.warn(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongObsIdentifier, observationId));
            }
            ED ed = (ED)obx.getObx5_ObservationValue(0).getData();
            String filename = ed.getEd3_DataSubtype().getValue();
            String encoding = ed.getEd4_Encoding().getValue();
            String data = ed.getEd5_Data().getValue();
            sequence = obx.getSetIDOBX().getValue();
            observationTime = obx.getObx14_DateTimeOfTheObservation().getValue();
            this.observation.add(new EncapsulatedData(filename, encoding, data, observationTime, commentNTE, group, sequence));
        } else if (this.isTextOrNumeric(valueType)) {
            name = this.determineName(obx);
            String value = "";
            Type tmp = obx.getObx5_ObservationValue(0).getData();
            if (tmp instanceof ST) {
                value = ((ST)tmp).getValue();
            } else if (tmp instanceof TX) {
                value = ((TX)tmp).getValue();
                if (value.contains("\\.br")) {
                    value = this.parseTextValue(value);
                }
            } else if (tmp instanceof FT) {
                value = this.parseFormattedTextValue(((FT)tmp).getValue());
            } else if (tmp instanceof NM) {
                value = ((NM)tmp).getValue();
            } else if (tmp instanceof SN) {
                value = ((SN)tmp).getSn2_Num1().getValue();
            } else if (tmp instanceof CE) {
                value = ((CE)tmp).getCe2_Text().getValue();
            }
            itemCode = obx.getObx3_ObservationIdentifier().getCwe1_Identifier().getValue();
            unit = obx.getObx6_Units().getCwe1_Identifier().getValue();
            range = obx.getObx7_ReferencesRange().getValue();
            String rawAbnormalFlags = obx.getObx8_AbnormalFlags(0).getValue();
            Boolean flag = this.isPathologic(rawAbnormalFlags);
            observationTime = obx.getObx14_DateTimeOfTheObservation().getValue();
            status = obx.getObx11_ObservationResultStatus().getValue();
            LabResultData lrd = new LabResultData(itemCode, name, unit, value, range, flag, rawAbnormalFlags, defaultDateTime, observationTime, commentNTE, group, sequence, status, this.extractName((Primitive)obx.getObx4_ObservationSubID()));
            if (valueType.equals("NM") || valueType.equals("SN")) {
                lrd.setIsNumeric(true);
            } else if (valueType.equals("TX")) {
                lrd.setIsPlainText(true);
            } else if (valueType.equals("FT")) {
                lrd.setIsFormatedText(true);
            }
            this.observation.add(lrd);
        } else {
            logger.error(MessageFormat.format("Value type {0} is not implemented!", valueType));
        }
    }

    private String determineName(OBX obx) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        possibleNames.add(obx.getObx4_ObservationSubID().getValue());
        possibleNames.add(obx.getObx3_ObservationIdentifier().getCwe2_Text().getValue());
        possibleNames.add(obx.getObx3_ObservationIdentifier().getCwe1_Identifier().getValue());
        return HL7Helper.determineName(possibleNames);
    }

    @Override
    public OrcMessage getOrcMessage() {
        try {
            ORU_R01_ORDER_OBSERVATION oo;
            ORU_R01_PATIENT_RESULT pr;
            ORU_R01 oru = (ORU_R01)this.message;
            if (oru != null && (pr = oru.getPATIENT_RESULT()) != null && (oo = pr.getORDER_OBSERVATION()) != null) {
                return this.extractOrc(oo.getORC());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HL7Reader.class).warn("orc parsing failed", (Throwable)e);
        }
        return null;
    }

    private OrcMessage extractOrc(ORC orc) throws HL7Exception {
        if (orc != null) {
            XCN[] ops;
            OrcMessage orcMessage = new OrcMessage();
            XCN[] xCNArray = ops = orc.getOrderingProvider();
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                XCN op = xCNArray[n2];
                FN fn = op.getFamilyName();
                ST familyName = null;
                if (fn != null && (familyName = fn.getSurname()) == null) {
                    familyName = fn.getOwnSurname();
                }
                this.addNameValuesToOrcMessage((Primitive)op.getGivenName(), (Primitive)familyName, orcMessage);
                ++n2;
            }
            return orcMessage;
        }
        return null;
    }
}

