/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.model;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.hl7.model.AbstractData;
import ch.elexis.hl7.util.HL7Helper;
import java.text.ParseException;
import java.util.Date;

public class LabResultData
extends AbstractData {
    private String code;
    private String unit;
    private String value;
    private String range;
    private String subId;
    private LabResultStatus resultStatus;
    private Date obrDateTime;
    private Boolean flag;
    private String rawAbnormalFlag;
    private boolean isNumeric = false;
    private boolean isFormatedText = false;
    private boolean isPlainText = false;

    public LabResultData(String code, String name, String unit, String value, String range, Boolean flag, String rawAbnormalFlag, String obrDateTime, String dateStr, String comment, String group, String sequence, String resultStatus, String subId) throws ParseException {
        super(name, dateStr, comment, group, sequence);
        this.setCode(code);
        this.setUnit(unit);
        this.setValue(value);
        this.setRange(range);
        this.setFlag(flag);
        this.setRawAbnormalFlag(rawAbnormalFlag);
        this.subId = subId;
        this.resultStatus = LabResultStatus.getStatus(resultStatus);
        if (obrDateTime != null && obrDateTime.length() > 0) {
            this.obrDateTime = HL7Helper.stringToDate(obrDateTime);
        }
    }

    public LabResultStatus getResultStatus() {
        return this.resultStatus;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public Date getOBRDateTime() {
        return this.obrDateTime;
    }

    public void setOBRDateTime(String obrDateTime) throws ElexisException {
        try {
            if (obrDateTime != null && obrDateTime.length() > 0) {
                this.obrDateTime = HL7Helper.stringToDate(obrDateTime);
            }
        }
        catch (ParseException e) {
            throw new ElexisException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean getFlag() {
        return this.flag;
    }

    public void setFlag(Boolean flag) {
        this.flag = flag;
    }

    public String getRawAbnormalFlag() {
        return this.rawAbnormalFlag;
    }

    public void setRawAbnormalFlag(String rawAbnormalFlag) {
        this.rawAbnormalFlag = rawAbnormalFlag;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public void setIsNumeric(boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public boolean isFormatedText() {
        return this.isFormatedText;
    }

    public void setIsFormatedText(boolean isFormatedText) {
        this.isFormatedText = isFormatedText;
    }

    public boolean isPlainText() {
        return this.isPlainText;
    }

    public void setIsPlainText(boolean isPlainText) {
        this.isPlainText = isPlainText;
    }

    public String getSubId() {
        return this.subId;
    }

    public void setSubId(String subId) {
        this.subId = subId;
    }

    public static enum LabResultStatus {
        UNDEFINED,
        FINAL,
        INTERMEDIATE,
        CHANGE;


        public static LabResultStatus getStatus(String code) {
            if ("F".equals(code)) {
                return FINAL;
            }
            if ("I".equals(code)) {
                return INTERMEDIATE;
            }
            if ("C".equals(code)) {
                return CHANGE;
            }
            return UNDEFINED;
        }
    }
}

