/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.dataaccess;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.ICodingService;
import java.util.List;
import java.util.Optional;

public class TextUtil {
    public static boolean isRiskfactor(IObservation iFinding) {
        if (iFinding.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : iFinding.getCoding()) {
                if (!IObservation.ObservationCode.ANAM_RISK.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPersAnamnese(IObservation iFinding) {
        if (iFinding instanceof IObservation && iFinding.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : iFinding.getCoding()) {
                if (!IObservation.ObservationCode.ANAM_PERSONAL.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getText(ICondition condition, ICodingService codingService) {
        Optional text;
        StringBuilder sb = new StringBuilder();
        Optional start = condition.getStart();
        Optional end = condition.getEnd();
        if (start.isPresent() || end.isPresent()) {
            sb.append("(");
            sb.append(start.orElse("")).append(" - ");
            sb.append(end.orElse(""));
            sb.append(") ");
        }
        boolean multiline = (text = condition.getText()).isPresent() && ((String)text.get()).contains("\n");
        sb.append(text.orElse("")).append(multiline ? "\n" : "");
        List coding = condition.getCoding();
        for (ICoding iCoding : coding) {
            sb.append(" [").append(codingService.getShortLabel(iCoding)).append("] ");
        }
        return sb.toString();
    }

    public static String getText(IObservation observation, ICodingService codingService) {
        StringBuilder sb = new StringBuilder();
        if (TextUtil.isPersAnamnese(observation)) {
            sb.append(observation.getText().orElse(""));
        } else if (TextUtil.isRiskfactor(observation)) {
            sb.append(observation.getText().orElse(""));
        }
        return sb.toString();
    }

    public static Object getText(IAllergyIntolerance allergy, ICodingService codingService) {
        StringBuilder sb = new StringBuilder();
        sb.append(allergy.getText().orElse(""));
        return sb.toString();
    }

    public static Object getText(IFamilyMemberHistory famanam, ICodingService codingService) {
        StringBuilder sb = new StringBuilder();
        sb.append(famanam.getText().orElse(""));
        return sb.toString();
    }
}

