/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.ObservationComponent;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;

public interface IObservation
extends IFinding {
    public List<IObservation> getSourceObservations(IObservationLink.ObservationLinkType var1);

    public void addSourceObservation(IObservation var1, IObservationLink.ObservationLinkType var2);

    public void removeSourceObservation(IObservation var1, IObservationLink.ObservationLinkType var2);

    public List<IObservation> getTargetObseravtions(IObservationLink.ObservationLinkType var1);

    public void addTargetObservation(IObservation var1, IObservationLink.ObservationLinkType var2);

    public void removeTargetObservation(IObservation var1, IObservationLink.ObservationLinkType var2);

    public void addComponent(ObservationComponent var1);

    public void updateComponent(ObservationComponent var1);

    public List<ObservationComponent> getComponents();

    public Optional<IEncounter> getEncounter();

    public void setEncounter(IEncounter var1);

    public Optional<LocalDateTime> getEffectiveTime();

    public void setEffectiveTime(LocalDateTime var1);

    public ObservationCategory getCategory();

    public void setCategory(ObservationCategory var1);

    public List<ICoding> getCoding();

    public void setCoding(List<ICoding> var1);

    public void setNumericValue(BigDecimal var1, String var2);

    public Optional<BigDecimal> getNumericValue();

    public void setStringValue(String var1);

    public Optional<String> getStringValue();

    public void setBooleanValue(Boolean var1);

    public Optional<Boolean> getBooleanValue();

    public void setDateTimeValue(Date var1);

    public Optional<Date> getDateTimeValue();

    public Optional<String> getNumericValueUnit();

    public void setObservationType(ObservationType var1);

    public ObservationType getObservationType();

    public boolean isReferenced();

    public void setReferenced(boolean var1);

    public void setComment(String var1);

    public Optional<String> getComment();

    public void addFormat(String var1, String var2);

    public String getFormat(String var1);

    public Optional<String> getScript();

    public void setScript(String var1);

    public int getDecimalPlace();

    public void setDecimalPlace(int var1);

    public Optional<String> getOriginUri();

    public void setOriginUri(String var1);

    public static enum ObservationCategory {
        SOCIALHISTORY("social-history"),
        VITALSIGNS("vital-signs"),
        IMAGING("imaging"),
        LABORATORY("laboratory"),
        PROCEDURE("procedure"),
        SURVEY("survey"),
        EXAM("exam"),
        THERAPY("therapy"),
        SOAP_SUBJECTIVE("subjective"),
        SOAP_OBJECTIVE("objective"),
        UNKNOWN("unknown");

        private String code;

        private ObservationCategory(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getLocalized() {
            try {
                String localized = ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.name());
                return localized;
            }
            catch (MissingResourceException e) {
                return this.toString();
            }
        }
    }

    public static enum ObservationCode {
        ANAM_PERSONAL(IdentifierSystem.ELEXIS_ANAMNESE, "personal"),
        ANAM_RISK(IdentifierSystem.ELEXIS_ANAMNESE, "risk");

        private String code;
        private IdentifierSystem identifierSystem;

        private ObservationCode(IdentifierSystem identifierSystem, String code) {
            this.code = code;
            this.identifierSystem = identifierSystem;
        }

        public String getCode() {
            return this.code;
        }

        public IdentifierSystem getIdentifierSystem() {
            return this.identifierSystem;
        }

        public boolean isSame(ICoding iCoding) {
            return this.code != null && this.code.equals(iCoding.getCode()) && this.identifierSystem != null && this.identifierSystem.getSystem() != null && this.identifierSystem.getSystem().equals(iCoding.getSystem());
        }
    }

    public static enum ObservationType {
        COMP,
        REF,
        NUMERIC,
        TEXT,
        DATE,
        BOOLEAN;

    }
}

