/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.LabItem;
import ch.elexis.core.jpa.entities.LabResult;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.LabOrderStateConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.jpa.entities.listener.LabOrderEntityListener;
import ch.elexis.core.model.LabOrderState;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="laborder")
@EntityListeners(value={LabOrderEntityListener.class, EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="LabOrder.orderid", query="SELECT lo FROM LabOrder lo WHERE  lo.deleted = false AND lo.orderid = :orderid"), @NamedQuery(name="LabOrder.item.patient.state", query="SELECT lo FROM LabOrder lo WHERE  lo.deleted = false AND lo.item = :item AND lo.patient = :patient AND lo.state = :state")})
public class LabOrder
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @OneToOne
    @JoinColumn(name="userid")
    private Kontakt user;
    @OneToOne
    @JoinColumn(name="mandant")
    private Kontakt mandator;
    @OneToOne
    @JoinColumn(name="patient")
    private Kontakt patient;
    @OneToOne
    @JoinColumn(name="item")
    private LabItem item;
    @OneToOne
    @JoinColumn(name="result")
    private LabResult result;
    @Column(length=128)
    private String orderid;
    @Column(length=255)
    private String groupname;
    @Column(length=24)
    private LocalDateTime time;
    @Column(length=24)
    private LocalDateTime observationTime;
    @Column(length=1)
    @Convert(converter=LabOrderStateConverter.class)
    private LabOrderState state;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    private boolean userResolved;
    static final long serialVersionUID = 5980972905508046133L;

    public LabOrder() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public Kontakt getUser() {
        return this._persistence_get_user();
    }

    public void setUser(Kontakt user) {
        this._persistence_set_user(user);
    }

    public Kontakt getMandator() {
        return this._persistence_get_mandator();
    }

    public void setMandator(Kontakt mandator) {
        this._persistence_set_mandator(mandator);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public LabItem getItem() {
        return this._persistence_get_item();
    }

    public void setItem(LabItem item) {
        this._persistence_set_item(item);
    }

    public LabResult getResult() {
        return this._persistence_get_result();
    }

    public void setResult(LabResult result) {
        this._persistence_set_result(result);
    }

    public String getOrderid() {
        return this._persistence_get_orderid();
    }

    public void setOrderid(String orderid) {
        this._persistence_set_orderid(orderid);
    }

    public String getGroupname() {
        return this._persistence_get_groupname();
    }

    public void setGroupname(String groupname) {
        this._persistence_set_groupname(groupname);
    }

    public LocalDateTime getTime() {
        return this._persistence_get_time();
    }

    public void setTime(LocalDateTime time) {
        this._persistence_set_time(time);
    }

    public LocalDateTime getObservationTime() {
        return this._persistence_get_observationTime();
    }

    public void setObservationTime(LocalDateTime observationTime) {
        this._persistence_set_observationTime(observationTime);
    }

    public LabOrderState getState() {
        return this._persistence_get_state();
    }

    public void setState(LabOrderState state) {
        this._persistence_set_state(state);
    }

    public boolean isUserResolved() {
        return this._persistence_get_userResolved();
    }

    public void setUserResolved(boolean userResolved) {
        this._persistence_set_userResolved(userResolved);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new LabOrder(persistenceObject);
    }

    public LabOrder(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "mandator") {
            return this.mandator;
        }
        if (string == "userResolved") {
            return this.userResolved;
        }
        if (string == "item") {
            return this.item;
        }
        if (string == "orderid") {
            return this.orderid;
        }
        if (string == "observationTime") {
            return this.observationTime;
        }
        if (string == "groupname") {
            return this.groupname;
        }
        if (string == "result") {
            return this.result;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "time") {
            return this.time;
        }
        if (string == "state") {
            return this.state;
        }
        if (string == "user") {
            return this.user;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "mandator") {
            this.mandator = (Kontakt)object;
            return;
        }
        if (string == "userResolved") {
            this.userResolved = (Boolean)object;
            return;
        }
        if (string == "item") {
            this.item = (LabItem)object;
            return;
        }
        if (string == "orderid") {
            this.orderid = (String)object;
            return;
        }
        if (string == "observationTime") {
            this.observationTime = (LocalDateTime)object;
            return;
        }
        if (string == "groupname") {
            this.groupname = (String)object;
            return;
        }
        if (string == "result") {
            this.result = (LabResult)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "time") {
            this.time = (LocalDateTime)object;
            return;
        }
        if (string == "state") {
            this.state = (LabOrderState)object;
            return;
        }
        if (string == "user") {
            this.user = (Kontakt)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Kontakt _persistence_get_mandator() {
        this._persistence_checkFetched("mandator");
        return this.mandator;
    }

    public void _persistence_set_mandator(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("mandator");
        this._persistence_propertyChange("mandator", this.mandator, kontakt);
        this.mandator = kontakt;
    }

    public boolean _persistence_get_userResolved() {
        this._persistence_checkFetched("userResolved");
        return this.userResolved;
    }

    public void _persistence_set_userResolved(boolean bl) {
        this._persistence_checkFetchedForSet("userResolved");
        this._persistence_propertyChange("userResolved", new Boolean(this.userResolved), new Boolean(bl));
        this.userResolved = bl;
    }

    public LabItem _persistence_get_item() {
        this._persistence_checkFetched("item");
        return this.item;
    }

    public void _persistence_set_item(LabItem labItem) {
        this._persistence_checkFetchedForSet("item");
        this._persistence_propertyChange("item", this.item, labItem);
        this.item = labItem;
    }

    public String _persistence_get_orderid() {
        this._persistence_checkFetched("orderid");
        return this.orderid;
    }

    public void _persistence_set_orderid(String string) {
        this._persistence_checkFetchedForSet("orderid");
        this._persistence_propertyChange("orderid", this.orderid, string);
        this.orderid = string;
    }

    public LocalDateTime _persistence_get_observationTime() {
        this._persistence_checkFetched("observationTime");
        return this.observationTime;
    }

    public void _persistence_set_observationTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("observationTime");
        this._persistence_propertyChange("observationTime", this.observationTime, localDateTime);
        this.observationTime = localDateTime;
    }

    public String _persistence_get_groupname() {
        this._persistence_checkFetched("groupname");
        return this.groupname;
    }

    public void _persistence_set_groupname(String string) {
        this._persistence_checkFetchedForSet("groupname");
        this._persistence_propertyChange("groupname", this.groupname, string);
        this.groupname = string;
    }

    public LabResult _persistence_get_result() {
        this._persistence_checkFetched("result");
        return this.result;
    }

    public void _persistence_set_result(LabResult labResult) {
        this._persistence_checkFetchedForSet("result");
        this._persistence_propertyChange("result", this.result, labResult);
        this.result = labResult;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public LocalDateTime _persistence_get_time() {
        this._persistence_checkFetched("time");
        return this.time;
    }

    public void _persistence_set_time(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("time");
        this._persistence_propertyChange("time", this.time, localDateTime);
        this.time = localDateTime;
    }

    public LabOrderState _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(LabOrderState labOrderState) {
        this._persistence_checkFetchedForSet("state");
        this._persistence_propertyChange("state", this.state, labOrderState);
        this.state = labOrderState;
    }

    public Kontakt _persistence_get_user() {
        this._persistence_checkFetched("user");
        return this.user;
    }

    public void _persistence_set_user(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_propertyChange("user", this.user, kontakt);
        this.user = kontakt;
    }
}

