/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.model;

import ch.myelexis.server.client.ApiClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"topic", "properties"})
public class ElexisEvent {
    public static final String JSON_PROPERTY_TOPIC = "topic";
    @Nullable
    private String topic;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    @Nullable
    private Map<String, String> properties = new HashMap<String, String>();

    public ElexisEvent topic(@Nullable String topic) {
        this.topic = topic;
        return this;
    }

    @Nullable
    @JsonProperty(value="topic", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty(value="topic", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTopic(@Nullable String topic) {
        this.topic = topic;
    }

    public ElexisEvent properties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ElexisEvent putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElexisEvent elexisEvent = (ElexisEvent)o;
        return Objects.equals(this.topic, elexisEvent.topic) && Objects.equals(this.properties, elexisEvent.properties);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ElexisEvent {\n");
        sb.append("    topic: ").append(this.toIndentedString(this.topic)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTopic() != null) {
            joiner.add(String.format(Locale.ROOT, "%stopic%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getTopic()))));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                joiner.add(String.format(Locale.ROOT, "%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), ApiClient.urlEncode(ApiClient.valueToString(this.getProperties().get(_key)))));
            }
        }
        return joiner.toString();
    }
}

