/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import ch.myelexis.server.model.IdentifiedRunnable;
import ch.myelexis.server.model.Task;
import ch.myelexis.server.model.TaskResult;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskServiceV1Api {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public TaskServiceV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskServiceV1Api(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(response.body(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public void activateTask(@Nonnull String id) throws ApiException {
        this.activateTask(id, null);
    }

    public void activateTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        this.activateTaskWithHttpInfo(id, headers);
    }

    public ApiResponse<Void> activateTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.activateTaskWithHttpInfo(id, null);
    }

    public ApiResponse<Void> activateTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.activateTaskRequestBuilder(id, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("activateTask", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder activateTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling activateTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}/$activate".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Task createTask(@Nonnull Task task) throws ApiException {
        return this.createTask(task, null);
    }

    public Task createTask(@Nonnull Task task, Map<String, String> headers) throws ApiException {
        ApiResponse<Task> localVarResponse = this.createTaskWithHttpInfo(task, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Task> createTaskWithHttpInfo(@Nonnull Task task) throws ApiException {
        return this.createTaskWithHttpInfo(task, null);
    }

    public ApiResponse<Task> createTaskWithHttpInfo(@Nonnull Task task, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createTaskRequestBuilder(task, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createTask", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Task responseValue = responseBody.isBlank() ? null : (Task)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Task>(){});
            localVarResponse.body().close();
            return new ApiResponse<Task>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createTaskRequestBuilder(@Nonnull Task task, Map<String, String> headers) throws ApiException {
        if (task == null) {
            throw new ApiException(400, "Missing the required parameter 'task' when calling createTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)task);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deactivateTask(@Nonnull String id) throws ApiException {
        this.deactivateTask(id, null);
    }

    public void deactivateTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        this.deactivateTaskWithHttpInfo(id, headers);
    }

    public ApiResponse<Void> deactivateTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.deactivateTaskWithHttpInfo(id, null);
    }

    public ApiResponse<Void> deactivateTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deactivateTaskRequestBuilder(id, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deactivateTask", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deactivateTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deactivateTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}/$deactivate".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deleteTask(@Nonnull String id) throws ApiException {
        this.deleteTask(id, null);
    }

    public void deleteTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        this.deleteTaskWithHttpInfo(id, headers);
    }

    public ApiResponse<Void> deleteTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.deleteTaskWithHttpInfo(id, null);
    }

    public ApiResponse<Void> deleteTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteTaskRequestBuilder(id, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteTask", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<TaskResult> findRunnableExecutions(@Nonnull String runnableId) throws ApiException {
        return this.findRunnableExecutions(runnableId, null);
    }

    public List<TaskResult> findRunnableExecutions(@Nonnull String runnableId, Map<String, String> headers) throws ApiException {
        ApiResponse<List<TaskResult>> localVarResponse = this.findRunnableExecutionsWithHttpInfo(runnableId, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<List<TaskResult>> findRunnableExecutionsWithHttpInfo(@Nonnull String runnableId) throws ApiException {
        return this.findRunnableExecutionsWithHttpInfo(runnableId, null);
    }

    public ApiResponse<List<TaskResult>> findRunnableExecutionsWithHttpInfo(@Nonnull String runnableId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.findRunnableExecutionsRequestBuilder(runnableId, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("findRunnableExecutions", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            List responseValue = responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<TaskResult>>(){});
            localVarResponse.body().close();
            return new ApiResponse<List<TaskResult>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder findRunnableExecutionsRequestBuilder(@Nonnull String runnableId, Map<String, String> headers) throws ApiException {
        if (runnableId == null) {
            throw new ApiException(400, "Missing the required parameter 'runnableId' when calling findRunnableExecutions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/runnable/{runnableId}/executions".replace("{runnableId}", ApiClient.urlEncode(runnableId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Task findTask(@Nonnull String id) throws ApiException {
        return this.findTask(id, null);
    }

    public Task findTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<Task> localVarResponse = this.findTaskWithHttpInfo(id, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Task> findTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.findTaskWithHttpInfo(id, null);
    }

    public ApiResponse<Task> findTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.findTaskRequestBuilder(id, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("findTask", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Task responseValue = responseBody.isBlank() ? null : (Task)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Task>(){});
            localVarResponse.body().close();
            return new ApiResponse<Task>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder findTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling findTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<TaskResult> findTaskExecutions(@Nonnull String id) throws ApiException {
        return this.findTaskExecutions(id, null);
    }

    public List<TaskResult> findTaskExecutions(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<List<TaskResult>> localVarResponse = this.findTaskExecutionsWithHttpInfo(id, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<List<TaskResult>> findTaskExecutionsWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.findTaskExecutionsWithHttpInfo(id, null);
    }

    public ApiResponse<List<TaskResult>> findTaskExecutionsWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.findTaskExecutionsRequestBuilder(id, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("findTaskExecutions", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            List responseValue = responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<TaskResult>>(){});
            localVarResponse.body().close();
            return new ApiResponse<List<TaskResult>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder findTaskExecutionsRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling findTaskExecutions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}/executions".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<Task> findTasks(@Nullable Boolean system) throws ApiException {
        return this.findTasks(system, null);
    }

    public List<Task> findTasks(@Nullable Boolean system, Map<String, String> headers) throws ApiException {
        ApiResponse<List<Task>> localVarResponse = this.findTasksWithHttpInfo(system, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<List<Task>> findTasksWithHttpInfo(@Nullable Boolean system) throws ApiException {
        return this.findTasksWithHttpInfo(system, null);
    }

    public ApiResponse<List<Task>> findTasksWithHttpInfo(@Nullable Boolean system, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.findTasksRequestBuilder(system, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("findTasks", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            List responseValue = responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<Task>>(){});
            localVarResponse.body().close();
            return new ApiResponse<List<Task>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder findTasksRequestBuilder(@Nullable Boolean system, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "system";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("system", system));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<IdentifiedRunnable> listRunnables() throws ApiException {
        return this.listRunnables(null);
    }

    public List<IdentifiedRunnable> listRunnables(Map<String, String> headers) throws ApiException {
        ApiResponse<List<IdentifiedRunnable>> localVarResponse = this.listRunnablesWithHttpInfo(headers);
        return localVarResponse.getData();
    }

    public ApiResponse<List<IdentifiedRunnable>> listRunnablesWithHttpInfo() throws ApiException {
        return this.listRunnablesWithHttpInfo(null);
    }

    public ApiResponse<List<IdentifiedRunnable>> listRunnablesWithHttpInfo(Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listRunnablesRequestBuilder(headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listRunnables", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            List responseValue = responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<IdentifiedRunnable>>(){});
            localVarResponse.body().close();
            return new ApiResponse<List<IdentifiedRunnable>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listRunnablesRequestBuilder(Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/runnable";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void refreshTask(@Nonnull String id) throws ApiException {
        this.refreshTask(id, null);
    }

    public void refreshTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        this.refreshTaskWithHttpInfo(id, headers);
    }

    public ApiResponse<Void> refreshTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.refreshTaskWithHttpInfo(id, null);
    }

    public ApiResponse<Void> refreshTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.refreshTaskRequestBuilder(id, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("refreshTask", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder refreshTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling refreshTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}/$refresh".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Task triggerRunnable(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.triggerRunnable(runnableId, requestBody, null);
    }

    public Task triggerRunnable(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        ApiResponse<Task> localVarResponse = this.triggerRunnableWithHttpInfo(runnableId, requestBody, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Task> triggerRunnableWithHttpInfo(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.triggerRunnableWithHttpInfo(runnableId, requestBody, null);
    }

    public ApiResponse<Task> triggerRunnableWithHttpInfo(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.triggerRunnableRequestBuilder(runnableId, requestBody, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("triggerRunnable", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Task responseValue = responseBody.isBlank() ? null : (Task)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Task>(){});
            localVarResponse.body().close();
            return new ApiResponse<Task>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder triggerRunnableRequestBuilder(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        if (runnableId == null) {
            throw new ApiException(400, "Missing the required parameter 'runnableId' when calling triggerRunnable");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling triggerRunnable");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/runnable/{runnableId}/$trigger".replace("{runnableId}", ApiClient.urlEncode(runnableId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(requestBody);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TaskResult triggerRunnableSync(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.triggerRunnableSync(runnableId, requestBody, null);
    }

    public TaskResult triggerRunnableSync(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        ApiResponse<TaskResult> localVarResponse = this.triggerRunnableSyncWithHttpInfo(runnableId, requestBody, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<TaskResult> triggerRunnableSyncWithHttpInfo(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.triggerRunnableSyncWithHttpInfo(runnableId, requestBody, null);
    }

    public ApiResponse<TaskResult> triggerRunnableSyncWithHttpInfo(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.triggerRunnableSyncRequestBuilder(runnableId, requestBody, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("triggerRunnableSync", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            TaskResult responseValue = responseBody.isBlank() ? null : (TaskResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TaskResult>(){});
            localVarResponse.body().close();
            return new ApiResponse<TaskResult>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder triggerRunnableSyncRequestBuilder(@Nonnull String runnableId, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        if (runnableId == null) {
            throw new ApiException(400, "Missing the required parameter 'runnableId' when calling triggerRunnableSync");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling triggerRunnableSync");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/runnable/{runnableId}/$trigger-sync".replace("{runnableId}", ApiClient.urlEncode(runnableId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(requestBody);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TaskResult triggerTask(@Nonnull String id) throws ApiException {
        return this.triggerTask(id, null);
    }

    public TaskResult triggerTask(@Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<TaskResult> localVarResponse = this.triggerTaskWithHttpInfo(id, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<TaskResult> triggerTaskWithHttpInfo(@Nonnull String id) throws ApiException {
        return this.triggerTaskWithHttpInfo(id, null);
    }

    public ApiResponse<TaskResult> triggerTaskWithHttpInfo(@Nonnull String id, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.triggerTaskRequestBuilder(id, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("triggerTask", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            TaskResult responseValue = responseBody.isBlank() ? null : (TaskResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TaskResult>(){});
            localVarResponse.body().close();
            return new ApiResponse<TaskResult>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder triggerTaskRequestBuilder(@Nonnull String id, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling triggerTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}/$trigger".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Task updateTask(@Nonnull String id, @Nonnull Task task) throws ApiException {
        return this.updateTask(id, task, null);
    }

    public Task updateTask(@Nonnull String id, @Nonnull Task task, Map<String, String> headers) throws ApiException {
        ApiResponse<Task> localVarResponse = this.updateTaskWithHttpInfo(id, task, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Task> updateTaskWithHttpInfo(@Nonnull String id, @Nonnull Task task) throws ApiException {
        return this.updateTaskWithHttpInfo(id, task, null);
    }

    public ApiResponse<Task> updateTaskWithHttpInfo(@Nonnull String id, @Nonnull Task task, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateTaskRequestBuilder(id, task, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateTask", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Task responseValue = responseBody.isBlank() ? null : (Task)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Task>(){});
            localVarResponse.body().close();
            return new ApiResponse<Task>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateTaskRequestBuilder(@Nonnull String id, @Nonnull Task task, Map<String, String> headers) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateTask");
        }
        if (task == null) {
            throw new ApiException(400, "Missing the required parameter 'task' when calling updateTask");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/services/task/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)task);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

