/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.innate;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.glassfish.jersey.innate.virtual.LoomishExecutors;

public final class VirtualThreadSupport {
    private static final LoomishExecutors VIRTUAL_THREADS = new Java21LoomishExecutors(Thread.ofVirtual().factory());
    private static final LoomishExecutors NON_VIRTUAL_THREADS = new NonLoomishExecutors(Executors.defaultThreadFactory());

    private VirtualThreadSupport() {
        throw new IllegalStateException();
    }

    public static boolean isVirtualThread() {
        return Thread.currentThread().isVirtual();
    }

    public static LoomishExecutors allowVirtual(boolean allow) {
        return allow ? VIRTUAL_THREADS : NON_VIRTUAL_THREADS;
    }

    public static LoomishExecutors allowVirtual(boolean allow, ThreadFactory threadFactory) {
        return allow ? new Java21LoomishExecutors(threadFactory) : new NonLoomishExecutors(threadFactory);
    }

    private static class Java21LoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private Java21LoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newThreadPerTaskExecutor(this.getThreadFactory());
        }

        @Override
        public ExecutorService newFixedThreadPool(int nThreads) {
            ThreadFactory threadFactory = this == VIRTUAL_THREADS ? Executors.defaultThreadFactory() : this.getThreadFactory();
            return Executors.newFixedThreadPool(nThreads, threadFactory);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public boolean isVirtual() {
            return true;
        }
    }

    private static class NonLoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private NonLoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newCachedThreadPool(this.getThreadFactory());
        }

        @Override
        public ExecutorService newFixedThreadPool(int nThreads) {
            return Executors.newFixedThreadPool(nThreads, this.getThreadFactory());
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

