/*
 * Decompiled with CFR 0.152.
 */
package org.cef.misc;

import java.util.concurrent.Callable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class SWTUtils {
    public static final boolean IS_WIN_MULTITHREAD = "win32".equals(SWT.getPlatform()) && Boolean.getBoolean("chromium.multi_threaded_message_loop");

    public static void syncExec(Runnable run) {
        if (Display.getCurrent() != null) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    public static <V> V syncExec(Callable<V> run) {
        ErrorHandlingCallable handling = new ErrorHandlingCallable(run);
        if (Display.getCurrent() != null) {
            handling.run();
        } else {
            Display.getDefault().syncExec(handling);
        }
        if (handling.exception != null) {
            throw new RuntimeException(handling.exception);
        }
        return (V)handling.result;
    }

    public static void asyncExec(Runnable run) {
        Display.getDefault().asyncExec(run);
    }

    public static void winMTExec(Runnable runn, boolean immediate) {
        if (IS_WIN_MULTITHREAD) {
            if (immediate) {
                runn.run();
            } else {
                SWTUtils.asyncExec(runn);
            }
        } else {
            SWTUtils.syncExec(runn);
        }
    }

    private static class ErrorHandlingCallable<T>
    implements Runnable {
        private Callable<T> runnable;
        private T result;
        private Exception exception;

        private ErrorHandlingCallable(Callable<T> runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.result = this.runnable.call();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

