/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;

public interface IStockService {
    public IStockEntry storeArticleInStock(IStock var1, IArticle var2);

    public IStockEntry storeArticleInStock(IStock var1, String var2);

    public void unstoreArticleFromStock(IStock var1, String var2);

    public Long getCumulatedStockForArticle(IArticle var1);

    public Availability getCumulatedAvailabilityForArticle(IArticle var1);

    public Availability getArticleAvailabilityForStock(IStock var1, String var2);

    @Deprecated
    public List<IStockEntry> findAllStockEntriesForStock(IStock var1);

    public List<IStockEntry> findAllStockEntriesForArticle(String var1);

    public IStockEntry findPreferredStockEntryForArticle(String var1, String var2);

    public IStockEntry findStockEntryForArticleInStock(IStock var1, String var2);

    public IStockEntry findStockEntryForArticleInStock(IStock var1, IArticle var2);

    public IStatus performSingleDisposal(IArticle var1, int var2, String var3);

    public IStatus performSingleDisposal(String var1, int var2, String var3);

    public IStatus performSingleReturn(IArticle var1, int var2, String var3);

    public IStatus performSingleReturn(String var1, int var2, String var3);

    default public Availability determineAvailability(int current, int min, boolean triggerOnIsBelow) {
        if (current <= 0) {
            return Availability.OUT_OF_STOCK;
        }
        if (triggerOnIsBelow && current >= min || !triggerOnIsBelow && current > min) {
            return Availability.IN_STOCK;
        }
        return Availability.CRITICAL_STOCK;
    }

    default public Availability determineAvailability(int current, int min) {
        return this.determineAvailability(current, min, false);
    }

    default public Availability determineAvailability(IStockEntry stockEntry) {
        return this.determineAvailability(stockEntry.getCurrentStock(), stockEntry.getMinimumStock(), true);
    }

    public List<IStock> getAllStocks(boolean var1, boolean var2);

    public List<IStockEntry> getAllStockEntries(boolean var1);

    public IStock getDefaultStock();

    public IStock getMandatorDefaultStock(String var1);

    public void setEnablePatientStock(IPatient var1, boolean var2);

    public Optional<IStock> getPatientStock(IPatient var1);

    public IStock getOrCreatePatientStock(IPatient var1);

    public List<IStock> getAllPatientStock();

    public void removePatientStock(IStock var1);

    public static enum Availability {
        IN_STOCK,
        CRITICAL_STOCK,
        OUT_OF_STOCK;

    }
}

