/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jaxrs.filter;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.jaxrs.filter.ContextSettingFilterUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.curity.oauth.AuthenticatedUser;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSettingFilter
implements Filter {
    private Logger logger;
    private final boolean IS_DISABLED_WEB_SECURITY;
    private IContextService contextService;
    private IModelService coreModelService;
    private IAccessControlService accessControlService;
    private LimitedLinkedHashMap<String, CacheEntry> verificationCache;
    private IUser disabledWebSecurityContextUser;

    public ContextSettingFilter(boolean disableWebSecurity) {
        this.IS_DISABLED_WEB_SECURITY = disableWebSecurity;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.verificationCache = new LimitedLinkedHashMap(100);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.contextService == null) {
            this.logger.debug("Initializing");
            this.initializeConsumedServices();
        }
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        this.clearContext();
        AuthenticatedUser authenticatedUser = (AuthenticatedUser)servletRequest.getAttribute("principal");
        if (authenticatedUser != null) {
            String jti = authenticatedUser.getClaim("jti").getAsString();
            if (!this.verificationCache.containsKey(jti)) {
                Long exp = authenticatedUser.getClaim("exp").getAsLong();
                String preferredUsername = authenticatedUser.getClaim("preferred_username").getAsString();
                String email = authenticatedUser.getClaim("email").getAsString();
                JsonElement realmAccess = authenticatedUser.getClaim("realm_access");
                JsonArray roles = realmAccess.getAsJsonObject().get("roles").getAsJsonArray();
                HashSet<String> rolesSet = new HashSet<String>(roles.size());
                roles.forEach(e -> {
                    boolean bl = rolesSet.add(e.getAsString());
                });
                AccessToken keycloakAccessToken = new AccessToken(null, null, TimeUtil.toDate(exp), preferredUsername, null, null);
                this.accessControlService.doPrivileged(() -> {
                    JsonElement elexisContactId;
                    Optional<IUser> user = this.coreModelService.load(preferredUsername, IUser.class);
                    if (user.isEmpty() && (elexisContactId = authenticatedUser.getClaim("elexisContactId")) != null) {
                        ContextSettingFilterUtil contextSettingFilterUtil = new ContextSettingFilterUtil();
                        IUser dynamicCreatedUser = contextSettingFilterUtil.performDynamicUserCreationIfApplicable(this.coreModelService, this.logger, this.contextService.getStationIdentifier(), preferredUsername, elexisContactId.getAsString(), email);
                        user = Optional.ofNullable(dynamicCreatedUser);
                    }
                    user.ifPresent(u -> {
                        CacheEntry cacheEntry = this.verificationCache.put(jti, new CacheEntry((IUser)u, keycloakAccessToken));
                    });
                });
                CacheEntry cacheEntry = (CacheEntry)this.verificationCache.get(jti);
                if (cacheEntry == null || cacheEntry.user == null) {
                    this.logger.warn("User [{}] not found in local database. Access denied.\"", (Object)preferredUsername);
                    servletResponse.sendError(401, "No matching local user");
                    return;
                }
                IContact userContact = cacheEntry.user.getAssignedContact();
                if (userContact == null) {
                    this.logger.warn("User [{}] has no assigned contact. Access denied.", (Object)preferredUsername);
                    servletResponse.sendError(401, "No assigned user contact");
                    return;
                }
                this.assertRoles(this.accessControlService, cacheEntry.user, rolesSet);
            }
            CacheEntry cacheEntry = (CacheEntry)this.verificationCache.get(jti);
            this.contextService.setActiveUser(cacheEntry.user);
            this.contextService.setTyped(cacheEntry.accessToken);
        } else if (this.IS_DISABLED_WEB_SECURITY) {
            this.activateDisabledWebSecurityUserContext();
        } else {
            throw new IllegalStateException("Web security enabled. No Authentication Info found.");
        }
        chain.doFilter(request, response);
    }

    private void clearContext() {
        this.contextService.setActiveCoverage(null);
        this.contextService.setActiveMandator(null);
        this.contextService.setActiveUser(null);
        this.contextService.setActivePatient(null);
        this.contextService.removeTyped(AccessToken.class);
    }

    private void initializeConsumedServices() {
        this.coreModelService = OsgiServiceUtil.getService(IModelService.class, "(service.model.name=ch.elexis.core.model)").get();
        this.contextService = OsgiServiceUtil.getService(IContextService.class).get();
        this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).get();
    }

    private synchronized void activateDisabledWebSecurityUserContext() {
        if (this.disabledWebSecurityContextUser == null) {
            this.accessControlService.doPrivileged(() -> {
                this.disabledWebSecurityContextUser = this.coreModelService.load("disabled-web-sec-user", IUser.class).orElse(null);
                if (this.disabledWebSecurityContextUser == null) {
                    IPerson webSecContact = (IPerson)new IContactBuilder.PersonBuilder(this.coreModelService, "disabled-web-sec-user", "delete-me", LocalDate.now(), Gender.MALE).buildAndSave();
                    this.disabledWebSecurityContextUser = (IUser)new IUserBuilder(this.coreModelService, "disabled-web-sec-user", webSecContact).build();
                    this.coreModelService.load("medical-user", IRole.class).ifPresent(this.disabledWebSecurityContextUser::addRole);
                    this.coreModelService.save(this.disabledWebSecurityContextUser);
                }
            });
        }
        this.contextService.setActiveUser(this.disabledWebSecurityContextUser);
    }

    private void assertRoles(IAccessControlService accessControlService, IUser user, Set<String> roles) {
        accessControlService.doPrivileged(() -> {
            Set allAvailableRoles = this.coreModelService.getQuery(IRole.class).execute().stream().map(r -> r.getId()).collect(Collectors.toSet());
            HashSet<String> targetUserRoleSet = new HashSet<String>(allAvailableRoles);
            targetUserRoleSet.retainAll(roles);
            Set currentUserRoleSet = user.getRoles().stream().map(r -> r.getId()).collect(Collectors.toSet());
            if (!Objects.equals(currentUserRoleSet, targetUserRoleSet)) {
                IUserService userService = OsgiServiceUtil.getService(IUserService.class).get();
                Set<String> effectiveUserRoles = userService.setUserRoles(user, targetUserRoleSet);
                accessControlService.refresh(user);
                this.logger.warn("[{}] Updated user/bot role set to {}", (Object)user, effectiveUserRoles);
            }
        });
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private record CacheEntry(IUser user, AccessToken accessToken) {
    }

    private class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -4811170640063577667L;
        private final int maxSize;

        public LimitedLinkedHashMap(int maxSize) {
            super(16, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

