/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ee;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IXid;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OpenIdUser
implements IUser {
    private final String preferredUsername;
    private final String name;
    private final String familyName;
    private final String associatedContactId;
    private final long issueTime;
    private final long expirationTime;
    private final Set<String> roles;
    private IContact associatedContact;

    public OpenIdUser(String preferredUsername, String name, String familyName, long issueTime, long expirationTime, String associatedContactId, Set<String> roles) {
        this.preferredUsername = preferredUsername;
        this.name = name;
        this.familyName = familyName;
        this.associatedContactId = associatedContactId;
        this.issueTime = issueTime;
        this.expirationTime = expirationTime;
        this.roles = roles;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void setDeleted(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.preferredUsername;
    }

    @Override
    public String getLabel() {
        return this.name + " " + this.familyName + " (" + this.getId() + ")";
    }

    @Override
    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    @Override
    public IXid getXid(String domain) {
        return null;
    }

    @Override
    public Long getLastupdate() {
        return this.issueTime * 1000L;
    }

    @Override
    public String getUsername() {
        return this.preferredUsername;
    }

    @Override
    public void setUsername(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHashedPassword() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHashedPassword(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSalt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSalt(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAssociatedContactId() {
        return this.associatedContactId;
    }

    @Override
    public IContact getAssignedContact() {
        return this.associatedContact;
    }

    @Override
    public void setAssignedContact(IContact value) {
        if (this.getAssociatedContactId().equals(value.getId())) {
            this.associatedContact = value;
        }
    }

    @Override
    public List<String> getRoleIds() {
        return new ArrayList<String>(this.roles);
    }

    @Override
    @Deprecated
    public List<IRole> getRoles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        return this.expirationTime > System.currentTimeMillis() / 1000L;
    }

    @Override
    public void setActive(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllowExternal() {
        return true;
    }

    @Override
    public void setAllowExternal(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAdministrator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAdministrator(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRole addRole(IRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRole(IRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IUser login(String username, char[] password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInternal() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getLabel() + " assignedContactId=" + this.associatedContactId + ", roles=" + String.valueOf(this.roles);
    }

    @Override
    public void setRoles(List<IRole> roles) {
        throw new UnsupportedOperationException();
    }
}

