/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.console;

import ch.elexis.core.console.CmdAdvisor;
import ch.elexis.core.console.CmdParam;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.equinox.console.completion.common.Completer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsoleCommandProvider
implements CommandProvider,
Completer {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Method> methods = new HashMap<String, Method>();
    private static LinkedHashMap<String, String> commandsHelp = new LinkedHashMap();
    private static boolean privileged_exec_mode = false;
    private String[] arguments;
    protected CommandInterpreter ci;
    private String[] subArguments;
    private String outcomeMessage;

    protected void register(Class<?> clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("__")) {
                methods.put(method.getName(), method);
            } else if (method.getName().startsWith("_")) {
                CmdAdvisor advisor = method.getDeclaredAnnotation(CmdAdvisor.class);
                String description = advisor != null ? advisor.description() : "";
                commandsHelp.put(method.getName().substring(1), description);
            }
            ++n2;
        }
    }

    public String getArgument(int i) {
        if (this.arguments.length >= i + 1) {
            return this.arguments[i];
        }
        return null;
    }

    public static boolean isPrivilegedMode() {
        return privileged_exec_mode;
    }

    protected void enablePrivilegedExecMode(boolean enablePrivilegedExecMode) {
        privileged_exec_mode = enablePrivilegedExecMode;
    }

    public void executeCommand(String root, CommandInterpreter ci) {
        this.ci = ci;
        this.arguments = this.collectArguments(root, ci);
        if (this.arguments.length == 0) {
            ci.println((Object)this.getHelp(root));
            return;
        }
        Method method = null;
        int i = this.arguments.length;
        while (i > 0) {
            String key = "__" + StringUtils.join((Object[])Arrays.copyOfRange(this.arguments, 0, i), (String)"_");
            method = methods.get(key);
            if (method != null) break;
            --i;
        }
        if (method == null) {
            this.printHelp(this.arguments);
            return;
        }
        this.subArguments = Arrays.copyOfRange(this.arguments, i, this.arguments.length);
        String joinedArguments = String.join((CharSequence)" ", this.arguments);
        ci.println((Object)("--( " + String.valueOf(new Date()) + " )---[cmd: " + joinedArguments + "]" + this.getRelativeFixedLengthSeparator(joinedArguments, 100, "-")));
        this.outcomeMessage = null;
        Object[] args = null;
        CmdAdvisor advisor = method.getDeclaredAnnotation(CmdAdvisor.class);
        if (method.getParameterCount() > 0) {
            args = new Object[method.getParameterCount()];
            Class<?>[] parameterTypes = method.getParameterTypes();
            int j = 0;
            while (j < parameterTypes.length) {
                Class<?> clazz = parameterTypes[j];
                if (clazz.equals(Iterator.class)) {
                    NoThrowExceptionIterator<String> nullContinueIterator;
                    args[j] = nullContinueIterator = new NoThrowExceptionIterator<String>(Arrays.asList(this.subArguments).iterator());
                } else if (clazz.equals(String.class)) {
                    args[j] = this.subArguments.length > j ? this.subArguments[j] : null;
                } else {
                    ci.println((Object)("invalid parameter type " + String.valueOf(clazz)));
                }
                ++j;
            }
        }
        Method _method = method;
        Object[] _args = args;
        if (privileged_exec_mode || advisor != null && advisor.executePrivileged()) {
            Optional<IAccessControlService> service = OsgiServiceUtil.getService(IAccessControlService.class);
            if (service.isPresent()) {
                service.get().doPrivileged(() -> this.performInvoke(_method, _args));
            } else {
                ci.println((Object)"No IAccessControlService available");
            }
        } else {
            this.performInvoke(_method, _args);
        }
    }

    private void performInvoke(Method method, Object[] args) {
        try {
            Object result = method.invoke((Object)this, args);
            if (result instanceof String) {
                this.ci.println(result);
            }
            if (this.outcomeMessage != null) {
                this.ci.println((Object)this.outcomeMessage);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.ci.println((Object)("Execution error on argument: " + e.getCause().getMessage()));
                this.logger.warn("Execution error on argument [{}]: ", (Object)this.arguments, (Object)e.getCause());
            }
            this.ci.println((Object)("Execution error on argument: " + e.getMessage()));
            this.logger.warn("Execution error on argument [{}]: ", (Object)this.arguments, (Object)e);
        }
    }

    private String[] collectArguments(String root, CommandInterpreter ci) {
        String argument;
        ArrayList<String> argumentQ = new ArrayList<String>();
        argumentQ.add(root);
        while ((argument = ci.nextArgument()) != null) {
            argumentQ.add(argument);
        }
        return argumentQ.toArray(new String[0]);
    }

    public String getRelativeFixedLengthSeparator(String value, int determinedLength, String separator) {
        if (value == null) {
            return "";
        }
        if (value.length() > determinedLength) {
            determinedLength = value.length() + 1;
        }
        return String.join((CharSequence)"", Collections.nCopies(determinedLength - value.length(), separator));
    }

    public void fail(String message) {
        this.outcomeMessage = "ERR " + message;
    }

    public String ok() {
        return "OK";
    }

    public void ok(Object object) {
        this.outcomeMessage = "OK " + String.valueOf(object);
    }

    public String missingArgument(String string) {
        return "Missing argument: " + string;
    }

    public String getHelp() {
        return this.getHelp("");
    }

    public void printHelp(String ... sub) {
        this.ci.println((Object)this.getHelp(sub));
    }

    private void addHeader(String header, StringBuilder help) {
        help.append("---");
        help.append(header);
        help.append("---");
        help.append("\n");
    }

    private void addCommand(String command, String params, String description, StringBuilder help) {
        help.append("   ");
        help.append(command);
        if (params != null) {
            help.append(params + " ");
        }
        help.append(" - ");
        help.append(description);
        help.append("\n");
    }

    private Set<String> getSubCommands(String ... sub) {
        String[] methodSignatures = methods.keySet().toArray(new String[0]);
        HashSet<String> relevant = new HashSet<String>();
        int i = 0;
        while (i < methodSignatures.length) {
            String key = methodSignatures[i];
            String[] splitMethodNames = key.substring(2).split("_");
            List<String> subList = Arrays.asList(sub);
            ArrayList<String> asList = new ArrayList<String>(Arrays.asList(splitMethodNames));
            int indexOfSubList = Collections.indexOfSubList(asList, subList);
            asList.removeAll(subList);
            if (indexOfSubList >= 0 && !asList.isEmpty()) {
                relevant.add((String)asList.get(0));
            }
            ++i;
        }
        return relevant;
    }

    public String getHelp(String ... sub) {
        StringBuilder sb = new StringBuilder();
        if (sub == null) {
            return this.printOverviewHelp();
        }
        if (StringUtils.isBlank((CharSequence)sub[0])) {
            return "";
        }
        sb.append(StringUtils.join((Object[])sub, (String)" "));
        sb.append(" ");
        Set<String> relevant = this.getSubCommands(sub);
        if (relevant.isEmpty()) {
            return "Sub/Command not found: " + StringUtils.join((Object[])sub, (String)" ");
        }
        ArrayList<String> helpList = new ArrayList<String>(relevant);
        Collections.sort(helpList, Comparator.naturalOrder());
        sb.append("(" + helpList.stream().reduce((u, t) -> u + " | " + t).orElse("") + ")\n");
        for (String string : helpList) {
            String methodKey = "__" + StringUtils.join((Object[])sub, (String)"_") + "_" + string;
            Method method = methods.get(methodKey);
            if (method != null) {
                CmdAdvisor advisor = method.getDeclaredAnnotation(CmdAdvisor.class);
                String _advisor = advisor != null ? advisor.description() : "";
                Parameter[] parameters = method.getParameters();
                String params = this.buildParamsBNFString(parameters);
                this.addCommand(string, params, _advisor, sb);
                continue;
            }
            sb.append("   " + string + " - [see subcommand]\n");
        }
        return sb.toString();
    }

    public Map<String, Integer> getCandidates(String buffer, int cursor) {
        Set<String> help = this.getSubCommands(buffer.split(" "));
        TreeSet<String> helpSorted = new TreeSet<String>(help);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String s : helpSorted) {
            map.put(s, buffer.length());
        }
        return map;
    }

    private String buildParamsBNFString(Parameter[] params) {
        StringBuilder sb = new StringBuilder();
        Parameter[] parameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter cmdParam = parameterArray[n2];
            CmdParam annotation = cmdParam.getAnnotation(CmdParam.class);
            if (annotation != null) {
                sb.append(" ");
                if (annotation.required()) {
                    sb.append(annotation.description().toUpperCase().replaceAll(" ", "_"));
                } else {
                    sb.append("[" + annotation.description().toUpperCase().replaceAll(" ", "_") + "]");
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private String printOverviewHelp() {
        StringBuilder sb = new StringBuilder();
        this.addHeader("Elexis Admin Commands", sb);
        for (Map.Entry<String, String> entry : commandsHelp.entrySet()) {
            String command = entry.getKey();
            String attributes = entry.getValue();
            this.addCommand(command, "", attributes, sb);
        }
        return sb.toString();
    }

    public void prflp(String value, int length) {
        this.prflp(value, length, false);
    }

    public void prflp(String value, int length, boolean endLine) {
        String abbreviated = StringUtils.abbreviate((String)value, (String)".. ", (int)length);
        this.ci.print((Object)String.format("%-" + length + "s", abbreviated));
        if (endLine) {
            this.ci.print((Object)"\n");
        }
    }

    private class NoThrowExceptionIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        public NoThrowExceptionIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            try {
                return this.iterator.next();
            }
            catch (NoSuchElementException nse) {
                return null;
            }
        }
    }
}

