/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac;

import ch.elexis.core.ac.Right;
import ch.elexis.core.ac.internal.ACEAccessBitMapJsonAdapter;
import com.google.gson.annotations.JsonAdapter;
import java.beans.Transient;
import java.util.Arrays;

@JsonAdapter(value=ACEAccessBitMapJsonAdapter.class)
public class ACEAccessBitMap {
    private final byte[] accessRightMap;
    private final boolean hasConstraint;

    public ACEAccessBitMap(byte[] accessRightMap) {
        this.accessRightMap = accessRightMap;
        this.hasConstraint = this.evaluateHasConstraint();
    }

    public byte[] getAccessRightMap() {
        return Arrays.copyOf(this.accessRightMap, this.accessRightMap.length);
    }

    public boolean isHasConstraint() {
        return this.hasConstraint;
    }

    private boolean evaluateHasConstraint() {
        byte[] byArray = this.accessRightMap;
        int n = this.accessRightMap.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b > 0 & b < 4) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Transient
    public boolean grants(Right right) {
        return this.accessRightMap[right.ordinal()] == 4;
    }
}

