/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;

public class KontaktMatcher {
    public static IContact matchAddress(IContact[] kk, String strasse, String plz, String ort, String natel) {
        int[] score = new int[kk.length];
        int i = 0;
        while (i < kk.length) {
            if (!StringTool.isNothing((Object)natel) && KontaktMatcher.normalizePhone(kk[i].getMobile()).equals(KontaktMatcher.normalizePhone(natel))) {
                int n = i;
                score[n] = score[n] + 5;
            }
            if (!StringTool.isNothing((Object)strasse)) {
                if (KontaktMatcher.isSameStreet(kk[i].getStreet(), strasse)) {
                    int n = i;
                    score[n] = score[n] + 3;
                } else {
                    int n = i;
                    score[n] = score[n] - 2;
                }
            }
            if (!StringTool.isNothing((Object)plz)) {
                if (plz.equals(kk[i].getZip())) {
                    int n = i;
                    score[n] = score[n] + 2;
                } else {
                    int n = i;
                    score[n] = score[n] - 1;
                }
            }
            if (!StringTool.isNothing((Object)ort)) {
                if (ort.equals(kk[i].getCity())) {
                    int n = i;
                    score[n] = score[n] + 1;
                } else {
                    int n = i;
                    score[n] = score[n] - 1;
                }
            }
            ++i;
        }
        IContact found = kk[0];
        int scored = score[0];
        int i2 = 1;
        while (i2 < score.length) {
            if (score[i2] > scored) {
                found = kk[i2];
                scored = score[i2];
            }
            ++i2;
        }
        return found;
    }

    public static String[] normalizeAddress(String str) {
        String[] ret = str.split("\\s+", 2);
        if (ret.length < 2) {
            String[] rx = new String[]{"", ret[0]};
            return rx;
        }
        return ret;
    }

    public static String normalizePhone(String nr) {
        return nr.replaceAll("[\\s-:\\.]", "");
    }

    public static boolean isSameStreet(String s1, String s2) {
        String[] ns2;
        String[] ns1 = KontaktMatcher.normalizeStrasse(s1);
        if (!ns1[0].matches((ns2 = KontaktMatcher.normalizeStrasse(s2))[0])) {
            return false;
        }
        return ns1[1].matches(ns2[1]);
    }

    static String[] normalizeStrasse(String strasse) {
        String[] m1 = StringTool.normalizeCase((String)strasse).split("\\s");
        int m1l = m1.length;
        StringBuilder m2 = new StringBuilder();
        m2.append(m1[0]);
        String nr = "0";
        if (m1l > 1) {
            if (m1[m1l - 1].matches("[0-9]+[a-zA-Z]")) {
                nr = m1[m1l - 1];
                --m1l;
            }
            if (m1l > 1) {
                int i = 1;
                while (i < m1l) {
                    m2.append(" ").append(m1[i]);
                    ++i;
                }
            }
        }
        return new String[]{m2.toString(), nr};
    }

    public static boolean isSame(IPerson a, String nameB, String firstnameB, String gebDatB) {
        block4: {
            block5: {
                String vorname2;
                String vorname1;
                String name1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getLastName()));
                String name2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(nameB));
                if (!name1.equals(name2) || !(vorname1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getFirstName()))).equals(vorname2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(firstnameB)))) break block4;
                if (!StringTool.isNothing((Object)a.getDateOfBirth()) && !StringTool.isNothing((Object)gebDatB)) break block5;
                return true;
            }
            try {
                TimeTool gd1 = new TimeTool(a.getDateOfBirth());
                TimeTool gd2 = new TimeTool(gebDatB);
                if (gd1.equals((Object)gd2)) {
                    return true;
                }
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
            }
        }
        return false;
    }

    public static boolean isSame(IPatient a, String nameB, String firstnameB, String gebDatB) {
        block4: {
            block5: {
                String vorname2;
                String vorname1;
                String name1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getDescription1()));
                String name2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(nameB));
                if (!name1.equals(name2) || !(vorname1 = StringTool.unambiguify((String)KontaktMatcher.simpleName(a.getDescription2()))).equals(vorname2 = StringTool.unambiguify((String)KontaktMatcher.simpleName(firstnameB)))) break block4;
                if (!StringTool.isNothing((Object)a.getDateOfBirth()) && !StringTool.isNothing((Object)gebDatB)) break block5;
                return true;
            }
            try {
                TimeTool gd1 = new TimeTool(a.getDateOfBirth());
                TimeTool gd2 = new TimeTool(gebDatB);
                if (gd1.equals((Object)gd2)) {
                    return true;
                }
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
            }
        }
        return false;
    }

    static String simpleName(String name) {
        String[] ret = name.split("\\s*[- ]\\s*");
        return ret[0];
    }
}

