/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.esr;

import ch.elexis.core.interfaces.INumericEnum;
import java.util.HashMap;

public enum ESRCode implements INumericEnum
{
    Gutschrift_edv(0),
    Storno_edv(1),
    Korrektur_edv(2),
    Gutschrift_Schalter(3),
    Storno_Schalter(4),
    Korrektur_Schalter(5),
    Summenrecord(6),
    Unbekannt(7);

    private int numeric;
    private static HashMap<Integer, ESRCode> numericMap;

    static {
        numericMap = new HashMap();
    }

    private ESRCode(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    public static ESRCode byNumeric(int numeric) {
        if (numericMap.isEmpty()) {
            ESRCode[] entries = ESRCode.values();
            int i = 0;
            while (i < entries.length) {
                numericMap.put(entries[i].numericValue(), entries[i]);
                ++i;
            }
        }
        return numericMap.getOrDefault(numeric, Unbekannt);
    }
}

