/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class ILabResultBuilder
extends AbstractBuilder<ILabResult> {
    private ILabOrder labOrder;

    public ILabResultBuilder(IModelService modelService, ILabItem labItem, IPatient patient) {
        super(modelService);
        this.object = modelService.create(ILabResult.class);
        ((ILabResult)this.object).setItem(labItem);
        ((ILabResult)this.object).setPatient(patient);
        ((ILabResult)this.object).setDate(LocalDate.now());
    }

    public ILabResultBuilder result(String result) {
        ((ILabResult)this.object).setResult(result);
        return this;
    }

    public ILabResultBuilder buildLabOrder(String orderId) {
        this.labOrder = this.modelService.create(ILabOrder.class);
        this.labOrder.setResult((ILabResult)this.object);
        this.labOrder.setItem(((ILabResult)this.object).getItem());
        this.labOrder.setOrderId(orderId);
        this.labOrder.setTimeStamp(LocalDateTime.now());
        return this;
    }

    @Override
    public ILabResult buildAndSave() {
        if (this.labOrder != null) {
            this.modelService.save(this.labOrder);
        }
        this.modelService.save(this.object);
        return (ILabResult)this.object;
    }
}

