/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eenv;

import ch.elexis.core.jdt.Nullable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AccessToken {
    private final String token;
    private final Date tokenIssuedAt;
    private final Date accessTokenExpiration;
    private final String username;
    private final String refreshToken;
    private final Date refreshTokenExpirationDate;
    private final String tokenEndpoint;
    private final String clientId;
    private final Map<String, String> claims;

    public AccessToken(String token, Date tokenIssuedAt, Date accessTokenExpiration, String username, String refreshToken, Date refreshTokenExpiration) {
        this(token, tokenIssuedAt, accessTokenExpiration, username, refreshToken, refreshTokenExpiration, null, null);
    }

    public AccessToken(String token, Date tokenIssuedAt, Date accessTokenExpiration, String username, String refreshToken, Date refreshTokenExpiration, String tokenEndpoint, String clientId) {
        this.token = token;
        this.tokenIssuedAt = tokenIssuedAt;
        this.accessTokenExpiration = accessTokenExpiration;
        this.username = username;
        this.refreshToken = refreshToken;
        this.refreshTokenExpirationDate = refreshTokenExpiration;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.claims = new HashMap<String, String>();
    }

    public String getToken() {
        return this.token;
    }

    public Date getAccessTokenExpiration() {
        return this.accessTokenExpiration;
    }

    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public Date refreshTokenExpiration() {
        return this.refreshTokenExpirationDate;
    }

    public Date getTokenIssuedAt() {
        return this.tokenIssuedAt;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void addClaim(String claim, String value) {
        this.claims.put(claim, value);
    }

    @Nullable
    public String getClaim(String claim) {
        return this.claims.get(claim);
    }
}

