/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.console.internal;

import ch.elexis.core.console.AbstractConsoleCommandProvider;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.utils.OsgiServiceUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={Prompt.class}, immediate=true, property={"osgi.command.scope=felix", "osgi.command.function=prompt"})
public class Prompt {
    private IContextService contextService;

    public String prompt() {
        if (this.contextService == null) {
            this.contextService = OsgiServiceUtil.getService(IContextService.class).orElse(null);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.contextService != null) {
            String userId = this.contextService.getActiveUser().map(Identifiable::getId).orElse(null);
            if (userId != null) {
                stringBuilder.append(userId);
            } else {
                stringBuilder.append("no-user");
            }
            String eeHostname = System.getenv("EE_HOSTNAME");
            if (eeHostname != null) {
                stringBuilder.append("@");
                stringBuilder.append(eeHostname.replaceAll(".myelexis.ch", ""));
            }
            if (AbstractConsoleCommandProvider.isPrivilegedMode()) {
                stringBuilder.append("# ");
            } else {
                stringBuilder.append("> ");
            }
        }
        return stringBuilder.toString();
    }
}

