/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public abstract class LazyCommonViewerContentProvider
extends CommonViewerContentProvider
implements ILazyContentProvider {
    protected Object[] loadedElements;

    public LazyCommonViewerContentProvider(CommonViewer commonViewer) {
        super(commonViewer);
    }

    @Override
    public void changed(HashMap<String, String> values) {
        if (this.commonViewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.commonViewer.notify(CommonViewer.Message.empty);
        } else {
            this.commonViewer.notify(CommonViewer.Message.notempty);
        }
        this.fieldFilterValues = values;
        this.asyncReload();
    }

    protected String getJobName() {
        return "Loading";
    }

    protected void asyncReload() {
        Job job = Job.create((String)this.getJobName(), (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                LazyCommonViewerContentProvider.this.loadedElements = LazyCommonViewerContentProvider.this.getElements(null);
                Display.getDefault().asyncExec(() -> {
                    AbstractTableViewer viewer = (AbstractTableViewer)LazyCommonViewerContentProvider.this.commonViewer.getViewerWidget();
                    if (viewer != null && !viewer.getControl().isDisposed()) {
                        viewer.setItemCount(LazyCommonViewerContentProvider.this.loadedElements.length);
                    }
                    LazyCommonViewerContentProvider.this.commonViewer.notify(CommonViewer.Message.update);
                });
            }
        });
        job.setPriority(20);
        job.schedule();
    }

    public void updateElement(int index) {
        if (this.loadedElements != null && this.loadedElements.length > 0) {
            Object o;
            Object[] copy = new Object[this.loadedElements.length];
            System.arraycopy(this.loadedElements, 0, copy, 0, this.loadedElements.length);
            if (index >= 0 && index < copy.length && (o = copy[index]) != null) {
                TableViewer tv = (TableViewer)this.commonViewer.getViewerWidget();
                tv.replace(o, index);
            }
        }
    }
}

