/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MoneyInput
extends Composite {
    Text text;
    List<SelectionListener> listeners = new LinkedList<SelectionListener>();

    public MoneyInput(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.text = new Text((Composite)this, 2048);
        this.prepare();
    }

    public MoneyInput(Composite parent, String label) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        new Label((Composite)this, 0).setText(label);
        this.text = new Text((Composite)this, 2048);
        this.prepare();
        this.text.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
    }

    public MoneyInput(Composite parent, String label, Money money) {
        this(parent, label);
        this.text.setText(money.getAmountAsString());
    }

    private void prepare() {
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    String t = MoneyInput.this.text.getText();
                    if (t.length() == 0) {
                        MoneyInput.this.text.setText(new Money().getAmountAsString());
                    } else {
                        Money.checkInput((String)t);
                    }
                    for (SelectionListener lis : MoneyInput.this.listeners) {
                        Event ev = new Event();
                        ev.widget = e.widget;
                        ev.display = e.display;
                        lis.widgetSelected(new SelectionEvent(ev));
                    }
                }
                catch (ParseException px) {
                    SWTHelper.alert(Messages.MoneyInput_InvalidAmountCaption, Messages.MoneyInput_InvalidAmountContents);
                }
            }
        });
    }

    public Money getMoney(boolean bNullIfEmpty) {
        String t = this.text.getText();
        if (StringTool.isNothing((Object)t)) {
            if (bNullIfEmpty) {
                return null;
            }
            return new Money();
        }
        try {
            return new Money(t);
        }
        catch (ParseException px) {
            ExHandler.handle((Throwable)px);
            return null;
        }
    }

    public void setMoney(String m) {
        this.text.setText(m);
    }

    public Text getControl() {
        return this.text;
    }

    public void addSelectionListener(SelectionListener lis) {
        this.listeners.add(lis);
    }

    public void removeSelectionListener(SelectionListener lis) {
        this.listeners.remove(lis);
    }

    public static Money getFromTextField(Text textField) {
        try {
            return new Money(textField.getText());
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }
}

