/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FormatValidator {
    private static final int AHV_NUM_LEN_WITHOUT_SEP = 13;
    private static final String AHV_SEP = ".";

    public static boolean isValidAHVNum(String ahvNum) {
        if (StringUtils.isBlank((CharSequence)ahvNum)) {
            return false;
        }
        return FormatValidator.isValidFormattedAHVNum(ahvNum) || FormatValidator.isValidUnformattedAHVNum(ahvNum);
    }

    public static boolean isValidFormattedAHVNum(String ahvToValidate) {
        return FormatValidator.hasAHVNumFormat(ahvToValidate) && FormatValidator.isControlDigitValid(ahvToValidate);
    }

    public static boolean isValidUnformattedAHVNum(String ahvToValidate) {
        if (FormatValidator.hasNumsWithLength(ahvToValidate, 13)) {
            return FormatValidator.isControlDigitValid(FormatValidator.getFormattedAHVNum(ahvToValidate));
        }
        return false;
    }

    private static boolean isControlDigitValid(String ahvNum) {
        int nextToLastIndex;
        String unformattedAHVNum = FormatValidator.getUnformattedAHVNum(ahvNum);
        int factor = 3;
        int total = 0;
        int i = nextToLastIndex = 11;
        while (i >= 0) {
            int value = Character.getNumericValue(unformattedAHVNum.charAt(i));
            total += value * factor;
            factor = factor == 3 ? 1 : 3;
            --i;
        }
        int nextMultipleOfTen = (int)Math.ceil((double)total / 10.0) * 10;
        int expectedControlDigit = nextMultipleOfTen - total;
        return FormatValidator.getControlDigit(ahvNum) == expectedControlDigit;
    }

    public static boolean hasAHVNumFormat(String ahvNum) {
        return Pattern.compile("[0-9]{3}\\.[0-9]{4}\\.[0-9]{4}\\.[0-9]{2}").matcher(ahvNum).matches();
    }

    public static boolean hasNumsWithLength(String value, int length) {
        return Pattern.compile("[0-9]{" + length + "}").matcher(value).matches();
    }

    public static boolean isValidMailAddress(String mailAddress) {
        return Pattern.compile("^[A-Z\u00c4\u00d6\u00dc\u00c0\u00c9\u00c8\u00e8\u00e9\u00e0\u00e4\u00f6\u00fc\u00df0-9._%+-]+@[A-Z\u00c4\u00d6\u00dc\u00c0\u00c9\u00c8\u00e8\u00e9\u00e0\u00e4\u00f6\u00fc\u00df0-9.-]+\\.[A-Z]{2,6}$", 2).matcher(mailAddress).matches();
    }

    public static String getUnformattedAHVNum(String str) {
        return str.replaceAll("[^0-9]", "");
    }

    public static int getControlDigit(String ahvNum) {
        return Character.getNumericValue(ahvNum.charAt(ahvNum.length() - 1));
    }

    public static String getFormattedAHVNum(String unformattedAhvNum) {
        if (FormatValidator.hasAHVNumFormat(unformattedAhvNum)) {
            return unformattedAhvNum;
        }
        String ahv1 = unformattedAhvNum.substring(0, 3);
        String ahv2 = unformattedAhvNum.substring(3, 7);
        String ahv3 = unformattedAhvNum.substring(7, 11);
        String ahv4 = unformattedAhvNum.substring(11);
        return ahv1 + AHV_SEP + ahv2 + AHV_SEP + ahv3 + AHV_SEP + ahv4;
    }
}

