/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ConfigServicePreferenceStore
extends EventManager
implements IPreferenceStore {
    @Inject
    private IConfigService configService;
    @Inject
    private IContextService contextService;
    private Scope scope;
    private ListenerList<IPropertyChangeListener> listeners;
    private IContact contact;

    public ConfigServicePreferenceStore(Scope scope) {
        CoreUiUtil.injectServices((Object)((Object)this));
        this.scope = scope;
        this.listeners = new ListenerList();
    }

    public ConfigServicePreferenceStore(IContact iContact) {
        CoreUiUtil.injectServices((Object)((Object)this));
        this.contact = iContact;
        this.listeners = new ListenerList();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean contains(String name) {
        if (name != null) {
            return this.getStringValue(name) != null;
        }
        return false;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        for (IPropertyChangeListener l : this.listeners) {
            l.propertyChange(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
        }
    }

    public boolean getBoolean(String name) {
        String value = this.getStringValue(name);
        if (value == null) {
            value = this.getDefaultStringValue(name);
        }
        return value == null ? false : "1".equals(value) || "true".equalsIgnoreCase(value);
    }

    public boolean getDefaultBoolean(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getBoolean(name + "_default");
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getDouble(name + "_default");
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getFloat(name + "_default");
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getInt(name + "_default");
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getLong(name + "_default");
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        String value = this.getDefaultStringValue(name);
        if (value != null) {
            return this.getString(name + "_default");
        }
        return "";
    }

    private String getDefaultStringValue(String name) {
        return this.getStringValue(name + "_default");
    }

    private String getStringValue(String name) {
        String value = null;
        if (this.scope == Scope.GLOBAL) {
            value = this.configService.get(name, null);
        } else if (this.scope == Scope.MANDATOR) {
            IMandator activeMandator = (IMandator)this.contextService.getActiveMandator().orElseThrow(() -> new IllegalStateException("No active mandator"));
            value = this.configService.get((IContact)activeMandator, name, null);
        } else if (this.scope == Scope.USER) {
            IContact activeUser = (IContact)this.contextService.getActiveUserContact().orElseThrow(() -> new IllegalStateException("No active user contact"));
            value = this.configService.get(activeUser, name, null);
        } else if (this.scope == Scope.LOCAL) {
            value = this.configService.getLocal(name, null);
        } else if (this.contact != null) {
            value = this.configService.get(this.contact, name, null);
        } else {
            throw new IllegalStateException("Unknown scope " + String.valueOf((Object)this.scope));
        }
        return value;
    }

    private void setStringValue(String name, String value) {
        if (this.scope == Scope.GLOBAL) {
            this.configService.set(name, value);
        } else if (this.scope == Scope.MANDATOR) {
            IMandator activeMandator = (IMandator)this.contextService.getActiveMandator().orElseThrow(() -> new IllegalStateException("No active mandator"));
            this.configService.set((IContact)activeMandator, name, value);
        } else if (this.scope == Scope.USER) {
            IContact activeUser = (IContact)this.contextService.getActiveUserContact().orElseThrow(() -> new IllegalStateException("No active user contact"));
            this.configService.set(activeUser, name, value);
        } else if (this.scope == Scope.LOCAL) {
            this.configService.setLocal(name, value);
        } else if (this.contact != null) {
            this.configService.set(this.contact, name, value);
        } else {
            throw new IllegalStateException("Unknown scope " + String.valueOf((Object)this.scope));
        }
    }

    public double getDouble(String name) {
        String value = this.getStringValue(name);
        try {
            return value == null ? Double.parseDouble(this.getDefaultStringValue(name)) : Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public float getFloat(String name) {
        String value = this.getStringValue(name);
        try {
            return value == null ? Float.parseFloat(this.getDefaultStringValue(name)) : Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int getInt(String name) {
        String value = this.getStringValue(name);
        try {
            return value == null ? Integer.parseInt(this.getDefaultStringValue(name)) : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLong(String name) {
        String value = this.getStringValue(name);
        try {
            return value == null ? Long.parseLong(this.getDefaultStringValue(name)) : Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getString(String name) {
        String value = this.getStringValue(name);
        return value == null ? this.getDefaultString(name) : value;
    }

    public boolean isDefault(String name) {
        if (name == null) {
            return false;
        }
        return this.getStringValue(name) == null;
    }

    public boolean needsSaving() {
        return false;
    }

    public void putValue(String name, String value) {
        this.setStringValue(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setDefault(String name, double value) {
        this.setValue(name + "_default", value);
    }

    public void setDefault(String name, float value) {
        this.setValue(name + "_default", value);
    }

    public void setDefault(String name, int value) {
        this.setValue(name + "_default", value);
    }

    public void setDefault(String name, long value) {
        this.setValue(name + "_default", value);
    }

    public void setDefault(String name, String value) {
        this.setValue(name + "_default", value);
    }

    public void setDefault(String name, boolean value) {
        this.setValue(name + "_default", value);
    }

    public void setToDefault(String name) {
        this.setStringValue(name, this.getStringValue(name + "_default"));
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        this.setStringValue(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, Float.valueOf(oldValue), Float.valueOf(value));
        this.setStringValue(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        if (this.scope == Scope.GLOBAL) {
            this.configService.set(name, value);
        } else if (this.scope == Scope.MANDATOR) {
            IMandator activeMandator = (IMandator)this.contextService.getActiveMandator().orElseThrow(() -> new IllegalStateException("No active mandator"));
            this.configService.set((IContact)activeMandator, name, value);
        } else if (this.scope == Scope.USER) {
            IContact activeUser = (IContact)this.contextService.getActiveUserContact().orElseThrow(() -> new IllegalStateException("No active user contact"));
            this.configService.set(activeUser, name, value);
        } else if (this.scope == Scope.LOCAL) {
            this.configService.setLocal(name, value);
        } else if (this.contact != null) {
            this.configService.set(this.contact, name, value);
        } else {
            throw new IllegalStateException("Unknown scope " + String.valueOf((Object)this.scope));
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        this.setStringValue(name, Long.toString(value));
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue.equals(value)) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        this.setStringValue(name, value);
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        if (this.scope == Scope.GLOBAL) {
            this.configService.set(name, value);
        } else if (this.scope == Scope.LOCAL) {
            this.configService.setLocal(name, value);
        } else if (this.scope == Scope.MANDATOR) {
            IMandator activeMandator = (IMandator)this.contextService.getActiveMandator().orElseThrow(() -> new IllegalStateException("No active mandator"));
            this.configService.set((IContact)activeMandator, name, value);
        } else if (this.scope == Scope.USER) {
            IContact activeUser = (IContact)this.contextService.getActiveUserContact().orElseThrow(() -> new IllegalStateException("No active user contact"));
            this.configService.set(activeUser, name, value);
        } else if (this.contact != null) {
            this.configService.set(this.contact, name, value);
        } else {
            throw new IllegalStateException("Unknown scope " + String.valueOf((Object)this.scope));
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public static enum Scope {
        GLOBAL,
        USER,
        MANDATOR,
        LOCAL,
        CONTACT;

    }
}

