/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.interfaces.IXid;
import ch.elexis.data.Xid;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MetaXid {
    String id;
    List<Identity> identities = new ArrayList<Identity>();

    public MetaXid(Element xidElement) {
        this.id = xidElement.getAttributeValue("id");
        List ids = xidElement.getChildren();
        for (Element identity : ids) {
            if (!identity.getName().equalsIgnoreCase("identity")) continue;
            Identity i = new Identity(identity.getAttributeValue("domain"), identity.getAttributeValue("domainID"), this.mapQuality(identity.getAttributeValue("quality")), Boolean.parseBoolean(identity.getAttributeValue("isGUID")), identity.getAttributeValue("date"));
            this.identities.add(i);
        }
    }

    public MetaXid(Xid xidObject) {
        this(xidObject.getObject());
    }

    public MetaXid(IPersistentObject obj) {
        List xids = obj.getXids();
        String bestID = obj.getId();
        int bestQuality = 1;
        boolean bestIsGuid = true;
        for (IXid xid : xids) {
            Identity i = new Identity(xid.getDomain(), xid.getDomainId(), xid.getQuality(), xid.isGUID(), new TimeTool(((Xid)xid).getLastUpdate()).toString(6));
            this.identities.add(i);
            if (i.quality <= bestQuality || !i.isGUID) continue;
            bestID = xid.getId();
            bestQuality = i.quality;
        }
        this.id = bestID;
    }

    public int match(MetaXid other) {
        int ret = 0;
        for (Identity i : other.identities) {
            if (!this.isMatching(i)) continue;
            if (i.isGUID) {
                return 3;
            }
            if (i.quality == 2) {
                if (ret == 1) {
                    ret = 2;
                    continue;
                }
                ret = 1;
                continue;
            }
            if (i.quality != 3) continue;
            ret = 2;
        }
        return ret;
    }

    public Element toElement(Namespace ns) {
        Element ret = new Element("xid", ns);
        ret.setAttribute("id", this.id);
        for (Identity i : this.identities) {
            Element ei = new Element("identity", ns);
            ei.setAttribute("domain", i.domain);
            ei.setAttribute("domainID", i.domainID);
            ei.setAttribute("quality", this.mapQuality(i.quality));
            ei.setAttribute("isGUID", Boolean.toString(i.isGUID));
            ei.setAttribute("date", i.tt.toString(6));
            ret.addContent((Content)ei);
        }
        return ret;
    }

    public boolean merge(MetaXid other) {
        for (Identity i : other.identities) {
            Identity dom = this.findDomain(i.domain);
            if (dom == null) {
                this.identities.add(i);
                continue;
            }
            if (i.domainID.equalsIgnoreCase(dom.domainID) || !i.tt.isBefore(dom.tt)) continue;
            i.domainID = dom.domainID;
            i.tt.set(dom.tt);
            i.quality = dom.quality;
            i.isGUID = dom.isGUID;
        }
        return true;
    }

    private Identity findDomain(String domain) {
        for (Identity i : this.identities) {
            if (!i.domain.equalsIgnoreCase(domain)) continue;
            return i;
        }
        return null;
    }

    private boolean isMatching(Identity i1) {
        for (Identity i : this.identities) {
            if (!i.domain.equalsIgnoreCase(i1.domain) || !i.domainID.equalsIgnoreCase(i1.domainID)) continue;
            return true;
        }
        return false;
    }

    private int mapQuality(String q) {
        if (q.equalsIgnoreCase("local")) {
            return 1;
        }
        if (q.equalsIgnoreCase("regional")) {
            return 2;
        }
        if (q.equalsIgnoreCase("global")) {
            return 3;
        }
        return -1;
    }

    private String mapQuality(int q) {
        switch (q) {
            case 3: {
                return "global";
            }
            case 1: {
                return "local";
            }
            case 2: {
                return "regional";
            }
        }
        return "undefined";
    }

    private class Identity {
        TimeTool tt;
        String domain;
        String domainID;
        int quality;
        boolean isGUID;

        Identity(String d, String i, int q, boolean guid, String date) {
            this.domain = d;
            this.domainID = i;
            this.quality = q;
            this.isGUID = guid;
            this.tt = new TimeTool(date);
        }
    }
}

