/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.tools.Result;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class BillActiveEncounterHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional selectedEncounter = ContextServiceHolder.get().getTyped(IEncounter.class);
        if (selectedEncounter.isPresent()) {
            Konsultation selectedKonsultation = (Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)selectedEncounter.get()));
            Result result = BillingUtil.getBillableResult((Konsultation)selectedKonsultation);
            if (result.isOK()) {
                List results = BillingUtil.createBills(this.getBillMap(selectedKonsultation));
                if (!results.isEmpty() && ((Result)results.get(0)).isOK()) {
                    Rechnung invoice = Rechnung.load((String)((IInvoice)((Result)results.get(0)).get()).getId());
                    new RnOutputDialog(UiDesk.getTopShell(), Collections.singletonList(invoice)).open();
                } else {
                    for (Result invoiceResult : results) {
                        if (invoiceResult.isOK()) continue;
                        this.showResult(invoiceResult, HandlerUtil.getActiveShell((ExecutionEvent)event));
                    }
                }
            } else {
                this.showResult(result, HandlerUtil.getActiveShell((ExecutionEvent)event));
            }
        }
        return null;
    }

    private void showResult(Result<?> result, Shell shell) {
        StringBuilder sb = new StringBuilder();
        for (Result.msg message : result.getMessages()) {
            if (message.getSeverity() == Result.SEVERITY.OK) continue;
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            sb.append(message.getText());
        }
        MessageDialog.openInformation((Shell)shell, (String)"Nicht verrechenbar", (String)("Die Konsultation kann nicht verrechnet werden.\n\n" + sb.toString()));
    }

    private Map<Rechnungssteller, Map<Fall, List<Konsultation>>> getBillMap(Konsultation encounter) {
        HashMap<Rechnungssteller, Map<Fall, List<Konsultation>>> ret = new HashMap<Rechnungssteller, Map<Fall, List<Konsultation>>>();
        ret.put(encounter.getMandant().getRechnungssteller(), Collections.singletonMap(encounter.getFall(), Collections.singletonList(encounter)));
        return ret;
    }
}

