/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.model.IReminder;
import ch.elexis.core.ui.reminder.part.nattable.RemiderRichTextUtil;
import ch.elexis.core.ui.reminder.part.nattable.ReminderColumn;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.slf4j.LoggerFactory;

public class ReminderBodyDataProvider
implements ISpanningDataProvider {
    private Object[][] dataMatrix;
    private int yOffFuture;
    private List<ReminderColumn> columns;

    public int getColumnCount() {
        if (this.dataMatrix != null) {
            return this.dataMatrix[0].length;
        }
        return 0;
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex >= 0 && rowIndex >= 0) {
            Object data = this.dataMatrix[rowIndex][columnIndex];
            if (data instanceof Integer) {
                return this.dataMatrix[rowIndex - (Integer)data][columnIndex];
            }
            return this.dataMatrix[rowIndex][columnIndex];
        }
        return null;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Object object = this.dataMatrix[rowIndex][columnIndex];
        if (object instanceof IReminder) {
            if (rowIndex > this.yOffFuture) {
                return RemiderRichTextUtil.richText((IReminder)object, true);
            }
            return RemiderRichTextUtil.richText((IReminder)object, true);
        }
        if (object instanceof String) {
            if (rowIndex == 0) {
                return RemiderRichTextUtil.richText((String)object, 2);
            }
            return RemiderRichTextUtil.richText((String)object);
        }
        return null;
    }

    public int getRowCount() {
        if (this.dataMatrix != null) {
            return this.dataMatrix.length;
        }
        return 0;
    }

    public void setDataValue(int arg0, int arg1, Object arg2) {
        throw new IllegalStateException("Edit data not supported");
    }

    public void reload() {
        if (this.columns == null || this.columns.isEmpty()) {
            this.dataMatrix = null;
            return;
        }
        LoggerFactory.getLogger(this.getClass()).info("RELOAD START");
        ArrayList<Map<String, List<IReminder>>> dataListMap = new ArrayList<Map<String, List<IReminder>>>();
        HashMap<String, Integer> maxMap = new HashMap<String, Integer>();
        for (ReminderColumn reminderColumn : this.columns) {
            List<IReminder> allReminders = reminderColumn.loadReminders();
            List<IReminder> overDueReminders = this.getOverDue(allReminders);
            List<IReminder> todayReminders = this.getToday(allReminders);
            List<IReminder> tomorrowReminders = this.getTomorrow(allReminders);
            List<IReminder> futureReminders = this.getFuture(allReminders);
            List<IReminder> noDueReminders = this.getNoDue(allReminders);
            dataListMap.add(Map.of("overdue", overDueReminders, "today", todayReminders, "tomorrow", tomorrowReminders, "future", futureReminders, "nodue", noDueReminders));
            maxMap.put("overdue", Math.max(maxMap.getOrDefault("overdue", 0), overDueReminders.size()));
            maxMap.put("today", Math.max(maxMap.getOrDefault("today", 0), todayReminders.size()));
            maxMap.put("tomorrow", Math.max(maxMap.getOrDefault("tomorrow", 0), tomorrowReminders.size()));
            maxMap.put("future", Math.max(maxMap.getOrDefault("future", 0), futureReminders.size()));
            maxMap.put("nodue", Math.max(maxMap.getOrDefault("nodue", 0), noDueReminders.size()));
        }
        this.dataMatrix = new Object[2 + (Integer)maxMap.get("overdue") + 1 + (Integer)maxMap.get("today") + 1 + (Integer)maxMap.get("tomorrow") + 1 + (Integer)maxMap.get("future") + 1 + (Integer)maxMap.get("nodue")][this.columns.size()];
        this.addColumnHeaderToMatrix(this.columns.stream().map(c -> c.getName()).toList().toArray(new String[this.columns.size()]));
        int yOff = 1;
        this.addHeaderToMatrix(0, yOff, "\u00dcberf\u00e4llig");
        ++yOff;
        int i = 0;
        while (i < this.columns.size()) {
            this.addListToMatrix(i, yOff, (List)((Map)dataListMap.get(i)).get("overdue"));
            ++i;
        }
        this.addHeaderToMatrix(0, yOff += ((Integer)maxMap.get("overdue")).intValue(), "Heute");
        ++yOff;
        i = 0;
        while (i < this.columns.size()) {
            this.addListToMatrix(i, yOff, (List)((Map)dataListMap.get(i)).get("today"));
            ++i;
        }
        this.addHeaderToMatrix(0, yOff += ((Integer)maxMap.get("today")).intValue(), "Morgen");
        ++yOff;
        i = 0;
        while (i < this.columns.size()) {
            this.addListToMatrix(i, yOff, (List)((Map)dataListMap.get(i)).get("tomorrow"));
            ++i;
        }
        this.yOffFuture = yOff += ((Integer)maxMap.get("tomorrow")).intValue();
        this.addHeaderToMatrix(0, yOff, "Sp\u00e4ter");
        ++yOff;
        i = 0;
        while (i < this.columns.size()) {
            this.addListToMatrix(i, yOff, (List)((Map)dataListMap.get(i)).get("future"));
            ++i;
        }
        this.addHeaderToMatrix(0, yOff += ((Integer)maxMap.get("future")).intValue(), "Ohne F\u00e4lligkeit");
        ++yOff;
        i = 0;
        while (i < this.columns.size()) {
            this.addListToMatrix(i, yOff, (List)((Map)dataListMap.get(i)).get("nodue"));
            ++i;
        }
        yOff += ((Integer)maxMap.get("nodue")).intValue();
        LoggerFactory.getLogger(this.getClass()).info("RELOAD DONE");
    }

    private void addColumnHeaderToMatrix(String[] headers) {
        this.dataMatrix[0] = headers;
    }

    private void addHeaderToMatrix(int xOff, int yOff, String string) {
        this.dataMatrix[yOff][xOff] = string;
    }

    private void addListToMatrix(int xOff, int yOff, List<IReminder> list) {
        if (!list.isEmpty()) {
            int i = 0;
            while (i < list.size()) {
                this.dataMatrix[i + yOff][xOff] = list.get(i);
                ++i;
            }
        }
    }

    private List<IReminder> getNoDue(List<IReminder> all) {
        return all.stream().filter(r -> r.getDue() == null).toList();
    }

    private List<IReminder> getFuture(List<IReminder> all) {
        return all.stream().filter(r -> r.getDue() != null && r.getDue().isAfter(LocalDate.now().plusDays(1L))).toList();
    }

    private List<IReminder> getTomorrow(List<IReminder> all) {
        return all.stream().filter(r -> r.getDue() != null && r.getDue().isEqual(LocalDate.now().plusDays(1L))).toList();
    }

    private List<IReminder> getToday(List<IReminder> all) {
        return all.stream().filter(r -> r.getDue() != null && r.getDue().isEqual(LocalDate.now())).toList();
    }

    private List<IReminder> getOverDue(List<IReminder> all) {
        return all.stream().filter(r -> r.getDue() != null && r.getDue().isBefore(LocalDate.now())).toList();
    }

    public void setColumns(List<ReminderColumn> columns) {
        this.columns = columns;
    }

    public List<ReminderColumn> getColumns() {
        return this.columns;
    }

    public DataCell getCellByPosition(int columnIndex, int rowIndex) {
        Object data = this.dataMatrix[rowIndex][columnIndex];
        int columnsSpan = rowIndex > 0 ? this.getColumnsSpan(data) : 1;
        return new DataCell(columnIndex, rowIndex, columnsSpan, 1);
    }

    private int getColumnsSpan(Object data) {
        if (data instanceof String) {
            return this.columns.size();
        }
        return 1;
    }

    public void setShowCompleted(Boolean value) {
        this.columns.stream().forEach(c -> c.setShowCompleted(value));
    }
}

