/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ReminderAdditionCellPainter
extends AbstractTextPainter {
    private Image tick = Images.IMG_TICK.getImage(ImageSize._16x16_DefaultIconSize);
    private Image link = Images.IMG_LINK.getImage(ImageSize._16x16_DefaultIconSize);

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String text = this.getAdditionText(cell, configRegistry);
        int textWidth = this.getLengthFromCache(gc, text) + this.spacing * 2 + 1;
        return textWidth + 2 + this.tick.getBounds().width;
    }

    private String getAdditionText(ILayerCell cell, IConfigRegistry configRegistry) {
        String text = this.convertDataType(cell, configRegistry);
        if (StringUtils.isNotBlank((CharSequence)text) && text.indexOf("<addition>") > -1) {
            String additionText = text.substring(text.indexOf("<addition>") + "<addition>".length(), text.indexOf("</addition>"));
            return additionText;
        }
        return "";
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        if (this.hasLink(cell, configRegistry)) {
            return this.tick.getBounds().height + 4 + this.link.getBounds().height;
        }
        return this.tick.getBounds().height;
    }

    private boolean hasLink(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getAdditionText(cell, configRegistry).contains("<link>");
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(bounds.intersection(originalClipping));
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        int fontHeight = gc.getFontMetrics().getHeight();
        String text = this.getAdditionText(cell, configRegistry);
        int textWidth = this.getLengthFromCache(gc, text) + this.spacing * 2 + 1;
        int numberOfNewLines = this.getNumberOfNewLines(text);
        int contentHeight = fontHeight * numberOfNewLines + this.lineSpacing * (numberOfNewLines - 1) + this.spacing * 2;
        if (numberOfNewLines == 1) {
            int contentWidth = Math.min(this.getLengthFromCache(gc, text), bounds.width);
            gc.drawText(text, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)contentWidth) + this.spacing, bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)contentHeight) + this.spacing, 7);
            int x = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)contentWidth) + this.spacing;
            int y = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)contentHeight) + this.spacing;
            int length = gc.textExtent((String)text).x;
            this.paintDecoration(cellStyle, gc, x, y, length, fontHeight);
        } else {
            String[] lines;
            int yStartPos = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)contentHeight);
            String[] stringArray = lines = text.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), bounds.width);
                gc.drawText(line, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)lineContentWidth) + this.spacing, yStartPos + this.spacing, 7);
                int x = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)lineContentWidth) + this.spacing;
                int y = yStartPos + this.spacing;
                int length = gc.textExtent((String)line).x;
                this.paintDecoration(cellStyle, gc, x, y, length, fontHeight);
                yStartPos += fontHeight;
                yStartPos += this.lineSpacing;
                ++n2;
            }
        }
        Rectangle imageBounds = this.tick.getBounds();
        gc.drawImage(this.tick, textWidth + bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width), bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height));
        if (this.hasLink(cell, configRegistry)) {
            imageBounds = this.link.getBounds();
            gc.drawImage(this.link, textWidth + bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width), bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height) + imageBounds.height + 4);
        }
    }

    protected void setNewMinLength(ILayerCell cell, int contentWidth) {
        int cellLength = cell.getBounds().width;
        if (cellLength < contentWidth) {
            ILayer layer = cell.getLayer();
            int columnPosition = cell.getColumnPosition();
            if (cell.isSpannedCell()) {
                columnPosition = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1;
                int i = cell.getOriginColumnPosition();
                while (i < columnPosition) {
                    contentWidth -= layer.getColumnWidthByPosition(i);
                    ++i;
                }
            }
            layer.doCommand((ILayerCommand)new ColumnResizeCommand(layer, columnPosition, contentWidth, true));
        }
    }

    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().width - availableLength;
    }
}

