/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.commands;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.builder.IReminderBuilder;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.reminder.dialogs.ReminderDetailDialog;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Shell;

public class CreateReminder {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Optional @Named(value="createReminder.responsible") String responsible, @Optional @Named(value="createReminder.responsiblegroup") String group, @Optional @Named(value="createReminder.patient") String patient, @Optional @Named(value="createReminder.popup") String popup) {
        IReminder reminder = (IReminder)new IReminderBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), Visibility.ALWAYS, ProcessStatus.OPEN, "").build();
        reminder.setType(Type.COMMON);
        ContextServiceHolder.get().getActiveUserContact().ifPresent(c -> reminder.addResponsible(c));
        ContextServiceHolder.get().getActivePatient().ifPresent(p -> reminder.setContact((IContact)p));
        if (responsible instanceof String) {
            if (responsible.length() > 4) {
                reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
                reminder.addResponsible((IContact)CoreModelServiceHolder.get().load(responsible, IContact.class).orElse(null));
            } else {
                reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
                reminder.setResponsibleAll(true);
            }
        }
        if (group instanceof String && group.length() > 1) {
            reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
            reminder.setGroup((IUserGroup)CoreModelServiceHolder.get().load(group, IUserGroup.class).orElse(null));
        }
        if (patient instanceof String && patient.length() > 4) {
            reminder.setContact((IContact)CoreModelServiceHolder.get().load(patient, IContact.class).orElse(null));
        }
        if (popup instanceof String && Boolean.valueOf(popup).booleanValue()) {
            if (reminder.getContact() != null && reminder.getContact().isPatient()) {
                reminder.setVisibility(Visibility.POPUP_ON_PATIENT_SELECTION);
            } else {
                reminder.setVisibility(Visibility.POPUP_ON_LOGIN);
            }
        }
        ReminderDetailDialog dialog = new ReminderDetailDialog(reminder, shell);
        dialog.open();
    }
}

