/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.model.IOrderEntry;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class MedicationHistoryComparator
extends ViewerComparator {
    private int propertyIndex = 0;
    private int direction = -1;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction *= -1;
        }
        this.propertyIndex = column;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        IOrderEntry orderEntry1 = (IOrderEntry)o1;
        IOrderEntry orderEntry2 = (IOrderEntry)o2;
        switch (this.propertyIndex) {
            case 0: {
                String articleName1 = orderEntry1.getArticle().getName();
                String articleName2 = orderEntry2.getArticle().getName();
                return Objects.compare(articleName1, articleName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
            }
            case 1: {
                String orderAmount1 = String.valueOf(orderEntry1.getAmount());
                String orderAmount2 = String.valueOf(orderEntry2.getAmount());
                return Objects.compare(orderAmount1, orderAmount2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
            }
            case 2: {
                String orderDate1 = orderEntry1.getOrder().getTimestamp().format(this.dateFormatter);
                String orderDate2 = orderEntry2.getOrder().getTimestamp().format(this.dateFormatter);
                return Objects.compare(orderDate1, orderDate2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
            }
        }
        return super.compare(viewer, o1, o2);
    }
}

