/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MedicationTableViewerContentProvider
implements IStructuredContentProvider {
    private List<IPrescription> input;
    private List<MedicationTableViewerItem> currentItems;
    private StructuredViewer viewer;
    private int pageSize;
    private int currentPageOffset;

    public MedicationTableViewerContentProvider(StructuredViewer viewer) {
        this.viewer = viewer;
        this.pageSize = 500;
        this.currentPageOffset = 0;
    }

    public void dispose() {
        this.viewer = null;
        this.currentItems = null;
        this.input = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof List) {
            this.currentPageOffset = 0;
            this.input = (List)newInput;
            this.createCurrentItems();
        } else {
            this.currentPageOffset = 0;
            this.input = Collections.emptyList();
            this.currentItems = Collections.emptyList();
        }
    }

    private void createCurrentItems() {
        this.currentItems = this.input.size() < this.pageSize ? MedicationTableViewerItem.createFromPrescriptionList(this.input, this.viewer) : (this.currentPageOffset + this.pageSize < this.input.size() ? MedicationTableViewerItem.createFromPrescriptionList(this.input.subList(this.currentPageOffset, this.currentPageOffset + this.pageSize), this.viewer) : MedicationTableViewerItem.createFromPrescriptionList(this.input.subList(this.currentPageOffset, this.input.size()), this.viewer));
    }

    public void nextPage() {
        if (this.currentPageOffset + this.pageSize < this.input.size()) {
            this.currentPageOffset += this.pageSize;
            this.createCurrentItems();
        }
    }

    public boolean hasNext() {
        return this.input != null && this.currentPageOffset + this.pageSize < this.input.size();
    }

    public void previousPage() {
        if (this.currentPageOffset >= this.pageSize) {
            this.currentPageOffset -= this.pageSize;
            this.createCurrentItems();
        }
    }

    public boolean hasPrevious() {
        return this.input != null && this.currentPageOffset >= this.pageSize;
    }

    public Object[] getElements(Object inputElement) {
        return this.currentItems.toArray();
    }

    public static class MedicationContentProviderComposite
    extends Composite {
        private Label currentState;
        private MedicationTableViewerContentProvider contentProvider;
        private ToolBarManager toolbarmgr;

        public MedicationContentProviderComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new RowLayout(256));
            this.createContent();
        }

        private void createContent() {
            this.currentState = new Label((Composite)this, 0);
            this.toolbarmgr = new ToolBarManager();
            this.toolbarmgr.add((IAction)new PreviousPage());
            this.toolbarmgr.add((IAction)new NextPage());
            this.toolbarmgr.createControl((Composite)this);
        }

        public void setContentProvider(MedicationTableViewerContentProvider contentProvider) {
            this.contentProvider = contentProvider;
            this.refresh();
        }

        public void refresh() {
            if (this.contentProvider != null && this.contentProvider.input != null) {
                this.currentState.setText(this.contentProvider.currentPageOffset + " - " + (this.contentProvider.currentPageOffset + this.contentProvider.pageSize) + " / " + this.contentProvider.input.size());
            } else {
                this.currentState.setText(" / ");
            }
            this.layout();
            IContributionItem[] iContributionItemArray = this.toolbarmgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update();
                ++n2;
            }
        }

        private class NextPage
        extends Action {
            private NextPage() {
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEXT.getImageDescriptor();
            }

            public void run() {
                MedicationContentProviderComposite.this.contentProvider.nextPage();
                MedicationContentProviderComposite.this.contentProvider.viewer.refresh();
                MedicationContentProviderComposite.this.refresh();
            }

            public boolean isEnabled() {
                return MedicationContentProviderComposite.this.contentProvider != null && MedicationContentProviderComposite.this.contentProvider.hasNext();
            }
        }

        private class PreviousPage
        extends Action {
            private PreviousPage() {
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_PREVIOUS.getImageDescriptor();
            }

            public void run() {
                MedicationContentProviderComposite.this.contentProvider.previousPage();
                MedicationContentProviderComposite.this.contentProvider.viewer.refresh();
                MedicationContentProviderComposite.this.refresh();
            }

            public boolean isEnabled() {
                return MedicationContentProviderComposite.this.contentProvider != null && MedicationContentProviderComposite.this.contentProvider.hasPrevious();
            }
        }
    }
}

