/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.views.BestellView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddArticleToOrderHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(AddArticleToOrderHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        List<IArticle> articlesToOrder = this.getArticlesToOrder(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection());
        if (articlesToOrder.isEmpty()) {
            log.debug("Skip handler execution as no articles are selected to add to an order!");
            return null;
        }
        try {
            BestellView bestellView = (BestellView)activePage.showView("ch.elexis.BestellenView");
            if (bestellView != null) {
                bestellView.addItemsToOrder(articlesToOrder);
            } else {
                log.error("Cant't load BestellView to add articles to order");
            }
            activePage.activate(activePart);
        }
        catch (PartInitException e) {
            log.error("Cant't load BestellView to add articles to order", (Throwable)e);
        }
        return null;
    }

    private List<IArticle> getArticlesToOrder(ISelection selection) {
        ArrayList<IArticle> articlesToOrder = new ArrayList<IArticle>();
        if (selection != null) {
            if (selection == null || selection.isEmpty()) {
                return articlesToOrder;
            }
            IStructuredSelection structSelcection = (IStructuredSelection)selection;
            List mtvItems = structSelcection.toList();
            for (MedicationTableViewerItem mtvItem : mtvItems) {
                IArticle arti;
                IPrescription p = mtvItem.getPrescription();
                if (p == null || (arti = p.getArticle()) == null) continue;
                articlesToOrder.add(arti);
            }
        }
        return articlesToOrder;
    }
}

