/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.DoubleStream;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;

public class LaborChartPopupManager {
    private Shell chartPopup;
    private Chart chart;
    private Patient actPatient;
    private Font legendFont;
    private List<Font> fonts = new ArrayList<Font>();

    public LaborChartPopupManager(Patient patient) {
        this.actPatient = patient;
    }

    public void createChartPopup(TreeItem item, MouseEvent e, TreeViewer viewer, Patient actPatient) {
        this.actPatient = actPatient;
        Shell parentShell = viewer.getControl().getShell();
        LaborItemResults laborItemResults = (LaborItemResults)item.getData();
        LabItem labItem = laborItemResults.getLabItem();
        if (labItem.getTyp().equals((Object)LabItemTyp.DOCUMENT)) {
            return;
        }
        this.disposeResources();
        this.chartPopup = new Shell(parentShell, 12);
        this.setupChartPopupLayout();
        this.chart = new Chart((Composite)this.chartPopup, 0);
        this.setupChartLayout(this.chart);
        ArrayList<LabResult> labResults = new ArrayList<LabResult>(laborItemResults.getAllResults());
        List<LabResult> lastSevenResults = this.getLastYearResults(labResults);
        this.configureChart(this.chart, lastSevenResults);
        this.chartPopup.setSize(700, 300);
        Point location = this.adjustPopupLocation(viewer.getControl().toDisplay(e.x, e.y), parentShell, this.chartPopup.getSize().x, this.chartPopup.getSize().y);
        this.chartPopup.setLocation(location.x, location.y);
        this.chartPopup.open();
        this.addDisposeListener();
    }

    public Chart createChart(Composite parent, List<LabResult> labResults, Patient patient) {
        this.actPatient = patient;
        this.chart = new Chart(parent, 0);
        this.setupChartLayout(this.chart);
        this.configureChart(this.chart, labResults);
        if (!labResults.isEmpty()) {
            String firstElement = labResults.get(0).toString();
            String title = firstElement.replaceAll("\\(.*", "").trim();
            this.chart.getTitle().setText(title);
        }
        this.chart.getLegend().setVisible(false);
        this.chart.getLegend().setPosition(131072);
        this.addDisposeListener();
        return this.chart;
    }

    private void setupChartPopupLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.chartPopup.setLayout((Layout)gridLayout);
    }

    public void setupChartLayout(Chart chart) {
        chart.setLayoutData((Object)new GridData(4, 4, true, true));
        chart.getTitle().setText("");
        chart.getAxisSet().getXAxis(0).getTitle().setText("");
        chart.getAxisSet().getYAxis(0).getTitle().setText("");
    }

    private void addDisposeListener() {
        if (this.chartPopup != null && !this.chartPopup.isDisposed()) {
            this.chartPopup.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LaborChartPopupManager.this.disposeResources();
                }
            });
        }
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LaborChartPopupManager.this.disposeResources();
                }
            });
        }
    }

    private void disposeResources() {
        for (Font font : this.fonts) {
            if (font == null || font.isDisposed()) continue;
            font.dispose();
        }
        this.fonts.clear();
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.dispose();
        }
        if (this.chartPopup != null && !this.chartPopup.isDisposed()) {
            this.chartPopup.dispose();
        }
    }

    public void configureChart(Chart chart, List<LabResult> labResults) {
        labResults.sort(Comparator.comparing(result -> result.getObservationTime().getTime()));
        ArrayList<Date> xSeriesList = new ArrayList<Date>();
        ArrayList<Double> ySeriesList = new ArrayList<Double>();
        ArrayList<String> specialValuesList = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        this.processLabResults(labResults, xSeriesList, ySeriesList, specialValuesList);
        double[] xSeries = xSeriesList.stream().mapToDouble(Date::getTime).toArray();
        double[] ySeries = ySeriesList.stream().mapToDouble(Double::doubleValue).toArray();
        String seriesName = this.getSeriesName(labResults);
        ILineSeries lineSeries = this.createLineSeries(chart, seriesName, xSeries, ySeries);
        double[] referenceRange = this.getReferenceRange(labResults);
        double[] axisRanges = this.adjustAxisRanges(chart, xSeries, ySeries, referenceRange, specialValuesList, dateFormat);
        this.plotAnnotations(chart, xSeries, ySeries, specialValuesList, referenceRange, axisRanges);
        this.plotDataPoints(chart, xSeries, ySeries, specialValuesList, referenceRange, labResults);
        chart.redraw();
    }

    private void plotDataPoints(Chart chart, double[] xSeries, double[] ySeries, List<String> specialValuesList, double[] referenceRange, List<LabResult> labResults) {
        int i = 0;
        while (i < xSeries.length) {
            Color symbolColor;
            double x = xSeries[i];
            double y = ySeries[i];
            LabResult labResult = labResults.get(i);
            String pointLabel = String.format("%.1f (%s)", y, labResult.getObservationTime().toString(4));
            ILineSeries pointSeries = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, pointLabel);
            pointSeries.setYSeries(new double[]{y});
            pointSeries.setXSeries(new double[]{x});
            pointSeries.setLineStyle(LineStyle.NONE);
            String specialValue = specialValuesList.get(i);
            int symbolSize = 4;
            pointSeries.setSymbolSize(symbolSize);
            if (specialValue.equals("<")) {
                symbolColor = chart.getDisplay().getSystemColor(12);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                pointSeries.setSymbolSize(6);
            } else if (specialValue.equals(">")) {
                symbolColor = chart.getDisplay().getSystemColor(14);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.TRIANGLE);
                pointSeries.setSymbolSize(7);
            } else if (specialValue.equals("<=")) {
                symbolColor = chart.getDisplay().getSystemColor(9);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            } else if (specialValue.equals(">=")) {
                symbolColor = chart.getDisplay().getSystemColor(3);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
            } else if (y < referenceRange[0] || y > referenceRange[1]) {
                symbolColor = chart.getDisplay().getSystemColor(3);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
            } else {
                symbolColor = chart.getDisplay().getSystemColor(6);
                pointSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
            }
            pointSeries.setSymbolColor(symbolColor);
            ++i;
        }
        this.legendFont = new Font((Device)chart.getDisplay(), "Arial", 8, 0);
        this.fonts.add(this.legendFont);
        chart.getLegend().setFont(this.legendFont);
        chart.redraw();
    }

    private List<LabResult> getLastYearResults(List<LabResult> labResults) {
        if (labResults.isEmpty()) {
            return new ArrayList<LabResult>();
        }
        int anzahlMonate = Integer.parseInt(ConfigServiceHolder.getUser((String)"anzahlMonate", (String)"12"));
        labResults.sort(Comparator.comparing(result -> result.getObservationTime().getTime()));
        Date lastResultDate = labResults.get(labResults.size() - 1).getObservationTime().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastResultDate);
        calendar.add(2, -anzahlMonate);
        Date oneYearAgo = calendar.getTime();
        ArrayList<LabResult> filteredResults = new ArrayList<LabResult>();
        for (LabResult result2 : labResults) {
            if (!result2.getObservationTime().getTime().after(oneYearAgo)) continue;
            filteredResults.add(result2);
        }
        return filteredResults;
    }

    private void processLabResults(List<LabResult> results, List<Date> xSeriesList, List<Double> ySeriesList, List<String> specialValuesList) {
        for (LabResult result : results) {
            try {
                TimeTool observationTime = result.getObservationTime();
                Date date = observationTime.getTime();
                xSeriesList.add(date);
                String resultValue = result.getResult();
                String specialValue = this.getSpecialValue(resultValue);
                double yValue = 0.0;
                if (resultValue != null && !resultValue.isEmpty()) {
                    if (specialValue.isEmpty()) {
                        yValue = Double.parseDouble(resultValue);
                    } else {
                        String cleanedValue = resultValue.replaceAll("[^0-9.]", "").trim();
                        if (!cleanedValue.isEmpty()) {
                            yValue = Double.parseDouble(cleanedValue);
                        }
                    }
                }
                ySeriesList.add(yValue);
                specialValuesList.add(specialValue);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private String getSpecialValue(String resultValue) {
        if (resultValue.startsWith("<")) {
            return "<";
        }
        if (resultValue.startsWith(">")) {
            return ">";
        }
        if (resultValue.startsWith("<=")) {
            return "<=";
        }
        if (resultValue.startsWith(">=")) {
            return ">=";
        }
        return "";
    }

    private String getSeriesName(List<LabResult> results) {
        return results.isEmpty() ? "Parameterwert" : results.get(0).getItem().getName();
    }

    private ILineSeries createLineSeries(Chart chart, String seriesName, double[] xSeries, double[] ySeries) {
        ILineSeries lineSeries = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesName);
        lineSeries.setYSeries(ySeries);
        lineSeries.setXSeries(xSeries);
        lineSeries.setLineStyle(LineStyle.SOLID);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        return lineSeries;
    }

    private double[] getReferenceRange(List<LabResult> results) {
        double[] referenceRange = new double[2];
        try {
            String[] referenceValues = "w".equals(this.actPatient.getGeschlecht()) ? results.get(0).getItem().getReferenceFemale().split("-") : results.get(0).getItem().getReferenceMale().split("-");
            referenceRange[0] = Double.parseDouble(referenceValues[0]);
            referenceRange[1] = Double.parseDouble(referenceValues[1]);
        }
        catch (Exception ex) {
            referenceRange[0] = Double.MIN_VALUE;
            referenceRange[1] = Double.MAX_VALUE;
        }
        return referenceRange;
    }

    private double[] adjustAxisRanges(Chart chart, double[] xSeries, double[] ySeries, double[] referenceRange, List<String> specialValuesList, SimpleDateFormat dateFormat) {
        if (xSeries.length == 0 || ySeries.length == 0) {
            double[] defaultRange = new double[]{0.0, 1.0, 0.0, 1.0};
            chart.getAxisSet().getXAxis(0).setRange(new Range(defaultRange[0], defaultRange[1]));
            chart.getAxisSet().getYAxis(0).setRange(new Range(defaultRange[2], defaultRange[3]));
            return defaultRange;
        }
        double xMin = DoubleStream.of(xSeries).min().orElse(0.0);
        double xMax = DoubleStream.of(xSeries).max().orElse(1.0);
        double yMin = this.getYMin(ySeries, referenceRange);
        double yMax = this.getYMax(ySeries, referenceRange);
        if (xMin == xMax) {
            xMin -= 1.0;
            xMax += 1.0;
        }
        if (yMin == yMax) {
            yMin -= 1.0;
            yMax += 1.0;
        }
        double xRange = xMax - xMin;
        double yRange = yMax - yMin;
        double xMinAdjusted = this.adjustMin(xMin, xRange);
        double xMaxAdjusted = this.adjustMax(xMax, xRange);
        double yMinAdjusted = this.adjustMin(yMin, yRange);
        double yMaxAdjusted = this.adjustMax(yMax, yRange);
        if (Double.isInfinite(xMinAdjusted) || Double.isNaN(xMinAdjusted)) {
            xMinAdjusted = 0.0;
        }
        if (Double.isInfinite(xMaxAdjusted) || Double.isNaN(xMaxAdjusted)) {
            xMaxAdjusted = 1.0;
        }
        if (Double.isInfinite(yMinAdjusted) || Double.isNaN(yMinAdjusted)) {
            yMinAdjusted = 0.0;
        }
        if (Double.isInfinite(yMaxAdjusted) || Double.isNaN(yMaxAdjusted)) {
            yMaxAdjusted = 1.0;
        }
        double[] xMinAdjustedArr = new double[]{xMinAdjusted};
        double[] xMaxAdjustedArr = new double[]{xMaxAdjusted};
        double[] yMinAdjustedArr = new double[]{yMinAdjusted};
        double[] yMaxAdjustedArr = new double[]{yMaxAdjusted};
        this.setupChartAxes(chart, yMinAdjustedArr, yMaxAdjustedArr, xMinAdjustedArr, xMaxAdjustedArr, dateFormat, specialValuesList);
        return new double[]{xMinAdjusted, xMaxAdjusted, yMinAdjusted, yMaxAdjusted};
    }

    private double getYMin(double[] ySeries, double[] referenceRange) {
        double yMin = DoubleStream.of(ySeries).min().orElse(0.0);
        double referenceRangeSize = referenceRange[1] - referenceRange[0];
        if (referenceRangeSize == Double.MAX_VALUE) {
            return yMin;
        }
        yMin = yMin >= referenceRange[0] ? referenceRange[0] - 0.2 * referenceRangeSize : (yMin -= 0.15 * (DoubleStream.of(ySeries).max().orElse(referenceRange[1]) - yMin));
        return yMin;
    }

    private double getYMax(double[] ySeries, double[] referenceRange) {
        double yMax = DoubleStream.of(ySeries).max().orElse(0.0);
        double referenceRangeSize = referenceRange[1] - referenceRange[0];
        if (referenceRangeSize == Double.MAX_VALUE) {
            return yMax;
        }
        yMax = yMax <= referenceRange[1] ? referenceRange[1] + 0.2 * referenceRangeSize : (yMax += 0.15 * (yMax - DoubleStream.of(ySeries).min().orElse(referenceRange[0])));
        return yMax;
    }

    private double adjustMin(double min, double range) {
        double adjusted = min - 0.15 * range;
        return adjusted == min ? adjusted - 1.0 : adjusted;
    }

    private double adjustMax(double max, double range) {
        double adjusted = max + 0.15 * range;
        return adjusted == max ? adjusted + 1.0 : adjusted;
    }

    private void setupChartAxes(Chart chart, double[] yMinAdjustedArr, double[] yMaxAdjustedArr, double[] xMinAdjustedArr, double[] xMaxAdjustedArr, final SimpleDateFormat dateFormat, List<String> specialValuesList) {
        FontData[] fontData;
        chart.getLegend().setVisible(false);
        chart.getAxisSet().getYAxis(0).getTitle().setText("");
        chart.getAxisSet().getXAxis(0).getTitle().setForeground(chart.getDisplay().getSystemColor(2));
        chart.getAxisSet().getYAxis(0).getTitle().setForeground(chart.getDisplay().getSystemColor(2));
        chart.getAxisSet().getXAxis(0).getTick().setForeground(chart.getDisplay().getSystemColor(2));
        chart.getAxisSet().getYAxis(0).getTick().setForeground(chart.getDisplay().getSystemColor(2));
        chart.getAxisSet().getXAxis(0).getTick().setFormat(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                long value = ((Number)obj).longValue();
                Date date = new Date(value);
                return dateFormat.format(date, toAppendTo, pos);
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        });
        chart.getAxisSet().getXAxis(0).setRange(new Range(xMinAdjustedArr[0], xMaxAdjustedArr[0]));
        chart.getAxisSet().getYAxis(0).setRange(new Range(yMinAdjustedArr[0], yMaxAdjustedArr[0]));
        FontData[] fontDataArray = fontData = chart.getTitle().getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(8);
            ++n2;
        }
        Font newFont = new Font((Device)chart.getDisplay(), fontData);
        chart.getTitle().setFont(newFont);
        this.fonts.add(newFont);
        chart.getTitle().setForeground(chart.getDisplay().getSystemColor(2));
    }

    private void plotAnnotations(final Chart chart, final double[] xSeries, final double[] ySeries, final List<String> specialValuesList, final double[] referenceRange, final double[] axisRanges) {
        chart.getPlotArea().addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(chart.getDisplay().getSystemColor(2));
                gc.setFont(chart.getFont());
                IAxis xAxis = chart.getAxisSet().getXAxis(0);
                IAxis yAxis = chart.getAxisSet().getYAxis(0);
                double xMinAdjusted = axisRanges[0];
                double xMaxAdjusted = axisRanges[1];
                LaborChartPopupManager.this.plotReferenceRange(gc, xAxis, yAxis, referenceRange, new double[]{xMinAdjusted}, new double[]{xMaxAdjusted});
                LaborChartPopupManager.this.plotDataAnnotations(gc, xSeries, ySeries, specialValuesList, xAxis, yAxis);
            }
        });
    }

    private void plotReferenceRange(GC gc, IAxis xAxis, IAxis yAxis, double[] referenceRange, double[] xMinAdjustedArr, double[] xMaxAdjustedArr) {
        if (referenceRange[0] != Double.MIN_VALUE && referenceRange[1] != Double.MAX_VALUE) {
            int yMinPixel = yAxis.getPixelCoordinate(referenceRange[0]);
            int yMaxPixel = yAxis.getPixelCoordinate(referenceRange[1]);
            gc.setBackground(this.chart.getDisplay().getSystemColor(5));
            gc.setAlpha(50);
            gc.fillRectangle(xAxis.getPixelCoordinate(xMinAdjustedArr[0]), yMaxPixel, xAxis.getPixelCoordinate(xMaxAdjustedArr[0]) - xAxis.getPixelCoordinate(xMinAdjustedArr[0]), yMinPixel - yMaxPixel);
            gc.setAlpha(255);
        }
    }

    private void plotDataAnnotations(GC gc, double[] xSeries, double[] ySeries, List<String> specialValuesList, IAxis xAxis, IAxis yAxis) {
        boolean lastWasLeft = false;
        int i = 0;
        while (i < xSeries.length) {
            double x = xSeries[i];
            double y = ySeries[i];
            String annotation = this.getAnnotation(y, specialValuesList.get(i));
            int xPixel = xAxis.getPixelCoordinate(x);
            int yPixel = yAxis.getPixelCoordinate(y);
            if (i > 0 && Math.abs(ySeries[i] - ySeries[i - 1]) < 1.0E-6) {
                if (lastWasLeft) {
                    gc.drawText(annotation, xPixel + 10, yPixel - 10, true);
                    lastWasLeft = false;
                } else {
                    gc.drawText(annotation, xPixel - gc.textExtent((String)annotation).x - 10, yPixel - 10, true);
                    lastWasLeft = true;
                }
            } else if (i > 0 && ySeries[i] < ySeries[i - 1]) {
                gc.drawText(annotation, xPixel + 10, yPixel - 10, true);
                lastWasLeft = false;
            } else {
                gc.drawText(annotation, xPixel - gc.textExtent((String)annotation).x - 10, yPixel - 10, true);
                lastWasLeft = true;
            }
            if (!specialValuesList.get(i).isEmpty()) {
                Font originalFont = gc.getFont();
                Font boldFont = new Font(gc.getDevice(), originalFont.getFontData()[0].getName(), originalFont.getFontData()[0].getHeight(), 1);
                gc.setFont(boldFont);
                gc.setForeground(this.chart.getDisplay().getSystemColor(3));
                gc.setFont(originalFont);
                boldFont.dispose();
                gc.setForeground(this.chart.getDisplay().getSystemColor(2));
            }
            ++i;
        }
    }

    private String getAnnotation(double y, String specialValue) {
        if (specialValue.equals("<")) {
            return String.format("< %.2f", y);
        }
        if (specialValue.equals(">")) {
            return String.format("> %.2f", y);
        }
        if (specialValue.equals("<=")) {
            return String.format("<= %.2f", y);
        }
        if (specialValue.equals(">=")) {
            return String.format(">= %.2f", y);
        }
        return String.format("%.2f", y);
    }

    public boolean dispose() {
        if (this.chartPopup != null && !this.chartPopup.isDisposed()) {
            this.chartPopup.dispose();
            this.legendFont.dispose();
            this.chartPopup = null;
        }
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.dispose();
            this.legendFont.dispose();
            this.chart = null;
        }
        return false;
    }

    private Point adjustPopupLocation(Point location, Shell parentShell, int popupWidth, int popupHeight) {
        Rectangle parentShellBounds = parentShell.getBounds();
        location.y = this.adjustPopupLocationY(location.y + 30, parentShellBounds, popupHeight);
        location.x = this.adjustPopupLocationX(location.x + 30, parentShellBounds, popupWidth);
        return location;
    }

    private int adjustPopupLocationY(int y, Rectangle parentShellBounds, int popupHeight) {
        if (y + popupHeight > parentShellBounds.y + parentShellBounds.height) {
            return y - popupHeight - 20;
        }
        return y + 20;
    }

    private int adjustPopupLocationX(int x, Rectangle parentShellBounds, int popupWidth) {
        if (x + popupWidth > parentShellBounds.x + parentShellBounds.width) {
            return x - popupWidth - 20;
        }
        return x + 20;
    }
}

