/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.laborlink;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.laboratory.dialogs.LaborVerordnungDialog;
import ch.elexis.core.ui.laboratory.views.LaborView;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.data.LabItem;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.IWorkbenchPart;

public class LaborLink
implements IKonsExtension {
    public static final String PROVIDER_ID = "laborlink";
    private static final String LABOR_COLOR = "ffc8c8";
    IRichTextDisplay textField;

    public String connect(IRichTextDisplay textField) {
        this.textField = textField;
        return PROVIDER_ID;
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColorFromRGB((String)LABOR_COLOR);
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        LaborView laborView = (LaborView)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.elexis.Labor");
        if (laborView != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, LabItem.class, 8)});
            Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)laborView);
        }
        return true;
    }

    public IAction[] getActions() {
        IAction[] ret = new IAction[]{new Action("Labor verordnen"){

            public void run() {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient == null) {
                    return;
                }
                TimeTool date = new TimeTool();
                LaborVerordnungDialog dialog = new LaborVerordnungDialog(UiDesk.getTopShell(), patient, date);
                if (dialog.open() == 0) {
                    LaborLink.this.textField.insertXRef(-1, "Labor", LaborLink.PROVIDER_ID, "");
                }
            }
        }};
        return ret;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void insert(Object o, int pos) {
    }
}

