/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportLabMapping
extends TitleAreaDialog {
    private Text filePath;
    private Button selectFilePath;

    public ImportLabMapping(Shell parentShell, LabItem act) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.Core_Import_Laboratory_Assignment);
        this.setTitle(Messages.Core_Import_Laboratory_Assignment);
        this.setMessage(Messages.ImportLabMapping_message);
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new GridLayout(2, false));
        this.filePath = new Text(ret, 2048);
        this.filePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectFilePath = new Button(ret, 8);
        this.selectFilePath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.selectFilePath.setText(Messages.ImportLabMapping_selectFile);
        this.selectFilePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ImportLabMapping.this.getShell());
                String selected = fileDialog.open();
                ImportLabMapping.this.filePath.setText(selected);
            }
        });
        return ret;
    }

    protected void okPressed() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.filePath.getText());
        }
        catch (FileNotFoundException fe) {
            this.setErrorMessage(String.format(Messages.ImportLabMapping_errorNotFound, this.filePath.getText()));
            return;
        }
        try {
            LabMapping.importMappingFromCsv((InputStream)fis);
        }
        catch (IOException ioe) {
            this.setErrorMessage(String.format(Messages.ImportLabMapping_errorProblems, this.filePath.getText()));
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportLabMapping_titleProblemDialog, (String)ioe.getMessage());
        }
        super.okPressed();
    }
}

