/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.core.ui.importer.div.importers.dialog.QueryOverwriteDialog;
import org.eclipse.swt.widgets.Display;

public class DefaultLabImportUiHandler
extends ImportHandler {
    public ImportHandler.OverwriteState askOverwrite(IPatient patient, ILabResult oldResult, TransientLabResult newResult) {
        QueryOverwriteDialogRunnable runnable = new QueryOverwriteDialogRunnable(patient, oldResult, newResult);
        Display.getDefault().syncExec((Runnable)runnable);
        int retVal = runnable.result;
        if (retVal == 4) {
            return ImportHandler.OverwriteState.OVERWRITEALL;
        }
        if (retVal == 2) {
            return ImportHandler.OverwriteState.OVERWRITE;
        }
        return ImportHandler.OverwriteState.IGNORE;
    }

    private class QueryOverwriteDialogRunnable
    implements Runnable {
        int result;
        private IPatient pat;
        private ILabResult oldResult;
        private TransientLabResult newResult;

        public QueryOverwriteDialogRunnable(IPatient pat, ILabResult oldResult, TransientLabResult newResult) {
            this.pat = pat;
            this.oldResult = oldResult;
            this.newResult = newResult;
        }

        @Override
        public void run() {
            StringBuilder message = new StringBuilder();
            message.append("Alter Wert\n").append(this.oldResult.getLabel());
            message.append("\n");
            message.append("Neuer Wert\n").append(this.newResult.getLabel());
            message.append("\n\n");
            message.append(Messages.HL7Parser_AskOverwrite);
            QueryOverwriteDialog qod = new QueryOverwriteDialog(UiDesk.getTopShell(), Messages.HL7Parser_LabAlreadyImported + this.pat.getLabel(), message.toString());
            this.result = qod.open();
        }
    }
}

