/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.jface.preference;

import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.ui.e4.jface.preference.URIFieldEditor;
import ch.elexis.core.utils.CoreUtil;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class URIFieldEditorComposite
extends Composite {
    private URIFieldEditor storePath;
    private String defaultPreference;
    private ComboViewer osCombo;
    private String scheme;

    public URIFieldEditorComposite(String defaultPreference, Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        this.defaultPreference = defaultPreference;
        this.createContent();
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.storePath.setPreferenceStore(preferenceStore);
        this.storePath.load();
        this.storePath.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                URIFieldEditorComposite.this.storePath.store();
            }
        });
    }

    private void createContent() {
        Combo comboOs = new Combo((Composite)this, 0);
        this.osCombo = new ComboViewer(comboOs);
        comboOs.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.osCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.osCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((CoreUtil.OS)element).name();
            }
        });
        this.osCombo.setInput((Object)CoreUtil.OS.values());
        this.storePath = new URIFieldEditor(PreferencesUtil.getOsSpecificPreferenceName((CoreUtil.OS)CoreUtil.getOperatingSystemType(), (String)this.defaultPreference), "", this);
        this.storePath.setEmptyStringAllowed(true);
        this.osCombo.addSelectionChangedListener(event -> {
            CoreUtil.OS selection = (CoreUtil.OS)event.getStructuredSelection().getFirstElement();
            String preferenceName = PreferencesUtil.getOsSpecificPreferenceName((CoreUtil.OS)selection, (String)this.defaultPreference);
            this.storePath.store();
            this.storePath.setPreferenceName(preferenceName);
            this.storePath.load();
        });
        this.osCombo.setSelection((ISelection)new StructuredSelection((Object)CoreUtil.getOperatingSystemType()));
    }

    public FieldEditor getFieldEditor() {
        return this.storePath;
    }

    public void setFixedScheme(String scheme) {
        this.scheme = scheme;
        if (this.storePath != null) {
            this.storePath.setFixedScheme("file");
        }
    }
}

