/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.controls;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.e4.providers.IdentifiableLabelProvider;
import ch.elexis.core.ui.icons.Images;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class IIdentifiableModifiableListComposite<T extends Identifiable>
extends Composite {
    private ListViewer identifiableListViewer;
    private Runnable addElementHandler;
    private Consumer<T> removeElementHandler;

    public IIdentifiableModifiableListComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Composite toolbar = new Composite((Composite)this, 0);
        GridLayout gl_toolbar = new GridLayout(2, false);
        gl_toolbar.marginHeight = 0;
        toolbar.setLayout((Layout)gl_toolbar);
        toolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnAdd = new Button(toolbar, 0);
        btnAdd.setImage(Images.IMG_ADDITEM.getImage());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IIdentifiableModifiableListComposite.this.addElementHandler.run();
                IIdentifiableModifiableListComposite.this.identifiableListViewer.refresh();
            }
        });
        Button btnRemove = new Button(toolbar, 0);
        btnRemove.setImage(Images.IMG_REMOVEITEM.getImage());
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = IIdentifiableModifiableListComposite.this.identifiableListViewer.getStructuredSelection();
                if (!structuredSelection.isEmpty()) {
                    structuredSelection.forEach(IIdentifiableModifiableListComposite.this.removeElementHandler);
                    IIdentifiableModifiableListComposite.this.identifiableListViewer.refresh();
                }
            }
        });
        this.identifiableListViewer = new ListViewer((Composite)this, 2560);
        this.identifiableListViewer.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider());
        this.identifiableListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List identifiableList = this.identifiableListViewer.getList();
        GridData gd_identifiableList = new GridData(4, 4, true, true, 1, 1);
        gd_identifiableList.minimumWidth = 150;
        identifiableList.setLayoutData((Object)gd_identifiableList);
        this.identifiableListViewer.addSelectionChangedListener(sel -> btnRemove.setEnabled(sel.getStructuredSelection().getFirstElement() != null));
    }

    public boolean setFocus() {
        return this.identifiableListViewer.getList().setFocus();
    }

    public StructuredViewer getStructuredViewer() {
        return this.identifiableListViewer;
    }

    protected void checkSubclass() {
    }

    public void setAddElementHandler(Runnable runnable) {
        this.addElementHandler = runnable;
    }

    public void setRemoveElementHandler(Consumer<T> consumer) {
        this.removeElementHandler = consumer;
    }
}

