/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.fhir;

import ca.uhn.fhir.context.FhirContext;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.documents.service.FhirTransformersHolder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.LoggerFactory;

public class FhirChCrlDocumentBundle {
    private IDocument document;
    private IPatient patient;
    private IMandator author;
    private Bundle bundle;

    public FhirChCrlDocumentBundle(IDocument iDocument, IPatient iPatient, IMandator iMandator) {
        this.document = iDocument;
        this.patient = iPatient;
        this.author = iMandator;
        this.createBundle();
    }

    private void createBundle() {
        try {
            Date now = new Date();
            this.bundle = new Bundle();
            this.bundle.setId("BundleFromPractitioner");
            this.bundle.setMeta(new Meta().setLastUpdated(now).setProfile(Collections.singletonList(new CanonicalType("http://fhir.ch/ig/ch-crl/StructureDefinition/ch-crl-bundle"))));
            this.bundle.setType(Bundle.BundleType.DOCUMENT);
            Bundle.BundleEntryComponent compositionEntry = this.bundle.addEntry();
            Composition composition = new Composition();
            compositionEntry.setResource((Resource)composition);
            composition.setId("CompFromPractitioner");
            composition.setMeta(new Meta().setLastUpdated(now).setProfile(Collections.singletonList(new CanonicalType("http://fhir.ch/ig/ch-crl/StructureDefinition/ch-crl-composition"))));
            composition.setStatus(Composition.CompositionStatus.FINAL);
            composition.setType(new CodeableConcept(new Coding("http://loinc.org", "72134-0", "Cancer event report")));
            composition.setDate(now);
            composition.setTitle("Report to the Cancer Registry");
            Bundle.BundleEntryComponent subjectEntry = this.bundle.addEntry();
            IFhirTransformer<?, ?> patientTransformer = FhirTransformersHolder.getTransformerFor(Patient.class, IPatient.class);
            Patient subject = (Patient)patientTransformer.getFhirObject((Object)this.patient).orElseThrow(() -> new IllegalStateException("Could not create subject"));
            subject.getExtension().clear();
            this.fixAhvIdentifier(subject);
            subjectEntry.setResource((Resource)subject);
            Bundle.BundleEntryComponent practitionerEntry = this.bundle.addEntry();
            IFhirTransformer<?, ?> practitionerTransformer = FhirTransformersHolder.getTransformerFor(Practitioner.class, IMandator.class);
            Practitioner practitioner = (Practitioner)practitionerTransformer.getFhirObject((Object)this.author).orElseThrow(() -> new IllegalStateException("Could not create autor"));
            practitioner.getExtension().clear();
            practitioner.getIdentifier().clear();
            practitionerEntry.setResource((Resource)practitioner);
            Bundle.BundleEntryComponent documentReferenceEntry = this.bundle.addEntry();
            DocumentReference documentReference = new DocumentReference();
            documentReferenceEntry.setResource((Resource)documentReference);
            documentReference.setId(this.document.getId());
            DocumentReference.DocumentReferenceContentComponent content = documentReference.addContent();
            content.setAttachment(new Attachment().setContentType("application/pdf").setData(IOUtils.toByteArray((InputStream)this.document.getContent())));
            composition.setSubject(new Reference((IAnyResource)subject));
            composition.setAuthor(Collections.singletonList(new Reference((IAnyResource)practitioner)));
            Composition.SectionComponent section = composition.addSection();
            section.addEntry(new Reference((IAnyResource)documentReference));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating FHIR bundle", (Throwable)e);
            throw new IllegalStateException("Error creating FHIR bundle", e);
        }
    }

    private void fixAhvIdentifier(Patient subject) {
        List identifiers = subject.getIdentifier();
        Optional<Identifier> ahvIdentifier = identifiers.stream().filter(id -> id.getSystem().equals("www.ahv.ch/xid")).findFirst();
        subject.getIdentifier().clear();
        ahvIdentifier.ifPresent(ahvId -> {
            Identifier identifier = new Identifier();
            identifier.setSystem("urn:oid:2.16.756.5.32");
            identifier.setValue(ahvId.getValue());
            subject.addIdentifier(identifier);
        });
    }

    public void writeTo(File file) throws IOException {
        FhirContext ctx = FhirContext.forR4();
        String serialized = ctx.newXmlParser().encodeResourceToString((IBaseResource)this.bundle);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter out = new FileWriter(file);){
            out.write(serialized);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

