/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.documents.FilterCategory;
import ch.elexis.core.ui.UiDesk;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DocumentsFilterBarComposite
extends Composite
implements ISelectionProvider {
    private DocumentTypeAction currentSelection = null;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private List<FilterCategory> filters;
    private ToolBarManager manager;

    public DocumentsFilterBarComposite(Composite parent, int style, List<FilterCategory> filters) {
        super(parent, style);
        this.filters = filters;
        this.createContent();
    }

    private void createContent() {
        this.setBackground(UiDesk.getColor((String)"weiss"));
        this.setLayout((Layout)new FillLayout());
        this.manager = new ToolBarManager(64);
        this.manager.createControl((Composite)this);
        this.refresh();
    }

    public void refresh() {
        this.updateVisible();
        this.updateSelected();
    }

    private void updateVisible() {
        this.manager.removeAll();
        if (this.filters != null) {
            for (FilterCategory cf : this.filters) {
                this.manager.add((IAction)new DocumentTypeAction(cf));
            }
        }
        this.manager.update(true);
        this.getParent().layout(true);
    }

    private void updateSelected() {
        this.fireSelectionChanged();
        this.manager.update(true);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.currentSelection != null && this.currentSelection.getFilter() != null) {
            return new StructuredSelection((Object)this.currentSelection.getFilter());
        }
        return new StructuredSelection((Object)this.filters.get(0));
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            listener.selectionChanged(event);
        }
    }

    private class DocumentTypeAction
    extends Action {
        private FilterCategory filter;

        public DocumentTypeAction(FilterCategory filter) {
            super(filter.getLabel(), 8);
            this.filter = filter;
        }

        public FilterCategory getFilter() {
            return this.filter;
        }

        public void run() {
            DocumentsFilterBarComposite.this.currentSelection = this;
            if (this.isChecked()) {
                DocumentsFilterBarComposite.this.fireSelectionChanged();
            }
            DocumentsFilterBarComposite.this.manager.update(true);
        }
    }
}

